/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.xmpp;

import java.util.Date;
import java.util.Iterator;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.apache.servicemix.jbi.jaxp.SourceMarshaler;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;

public class XMPPMarshaler {
    private SourceMarshaler sourceMarshaler;
    private String messageBodyOpenTag = "<message>";
    private String messageBodyCloseTag = "</message>";

    public XMPPMarshaler() {
        this(new SourceMarshaler());
    }

    public XMPPMarshaler(SourceMarshaler sourceMarshaler) {
        this.sourceMarshaler = sourceMarshaler;
    }

    public void toNMS(NormalizedMessage normalizedMessage, Packet packet) throws MessagingException {
        Message message;
        String text;
        this.addNmsProperties(normalizedMessage, packet);
        if (packet instanceof Message && (text = (message = (Message)packet).getBody()) != null) {
            Source source = this.sourceMarshaler.asSource(this.messageBodyOpenTag + text + this.messageBodyCloseTag);
            normalizedMessage.setContent(source);
        }
        normalizedMessage.setProperty("org.apache.servicemix.xmpp.packet", (Object)packet);
    }

    public void fromNMS(Message message, MessageExchange exchange, NormalizedMessage normalizedMessage) throws TransformerException {
        String xml = this.messageAsString(normalizedMessage);
        message.setBody(xml);
        this.addJabberProperties(message, exchange, normalizedMessage);
    }

    public SourceMarshaler getSourceMarshaler() {
        return this.sourceMarshaler;
    }

    public void setSourceMarshaler(SourceMarshaler sourceMarshaler) {
        this.sourceMarshaler = sourceMarshaler;
    }

    public String getMessageBodyOpenTag() {
        return this.messageBodyOpenTag;
    }

    public void setMessageBodyOpenTag(String messageBodyOpenTag) {
        this.messageBodyOpenTag = messageBodyOpenTag;
    }

    public String getMessageBodyCloseTag() {
        return this.messageBodyCloseTag;
    }

    public void setMessageBodyCloseTag(String messageBodyCloseTag) {
        this.messageBodyCloseTag = messageBodyCloseTag;
    }

    protected String messageAsString(NormalizedMessage normalizedMessage) throws TransformerException {
        return this.sourceMarshaler.asString(normalizedMessage.getContent());
    }

    protected void addJabberProperties(Message message, MessageExchange exchange, NormalizedMessage normalizedMessage) {
        for (String name : normalizedMessage.getPropertyNames()) {
            Object value;
            if (!this.shouldIncludeHeader(normalizedMessage, name, value = normalizedMessage.getProperty(name))) continue;
            message.setProperty(name, value);
        }
        message.setProperty("exchangeId", (Object)exchange.getExchangeId());
        this.setProperty(message, "interface", exchange.getInterfaceName());
        this.setProperty(message, "operation", exchange.getOperation());
        this.setProperty(message, "service", exchange.getService());
        ServiceEndpoint endpoint = exchange.getEndpoint();
        if (endpoint != null) {
            message.setProperty("endpointName", (Object)endpoint.getEndpointName());
        }
    }

    protected void setProperty(Message message, String name, QName qName) {
        if (qName != null) {
            message.setProperty(name, (Object)qName.toString());
        }
    }

    protected void addNmsProperties(NormalizedMessage normalizedMessage, Packet message) {
        Iterator iter = message.getPropertyNames();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Object value = message.getProperty(name);
            normalizedMessage.setProperty(name, value);
        }
    }

    protected boolean shouldIncludeHeader(NormalizedMessage normalizedMessage, String name, Object value) {
        return value instanceof String || value instanceof Number || value instanceof Date;
    }
}

