/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.xmpp;

import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.common.util.MessageUtil;
import org.apache.servicemix.xmpp.XMPPConstants;
import org.apache.servicemix.xmpp.XMPPEndpointType;
import org.apache.servicemix.xmpp.marshaler.XMPPMarshalerSupport;
import org.apache.servicemix.xmpp.marshaler.impl.DefaultXMPPMarshaler;
import org.jivesoftware.smack.AccountManager;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smackx.muc.MultiUserChat;

public class XMPPSenderEndpoint
extends ProviderEndpoint
implements XMPPEndpointType {
    private XMPPMarshalerSupport marshaler = new DefaultXMPPMarshaler();
    private XMPPConnection connection;
    private String host;
    private int port = -1;
    private String user;
    private String password;
    private String resource;
    private String room;
    private String participant;
    private String proxyHost;
    private String proxyPort;
    private String proxyUser;
    private String proxyPass;
    private String proxyType;
    private boolean login = true;
    private boolean createAccount;
    private ConnectionConfiguration connectionConfig;
    private ProxyInfo proxyInfo;
    private Chat userChat;
    private MultiUserChat chatRoom;

    public void validate() throws DeploymentException {
        super.validate();
        if (this.host == null || this.host.trim().length() < 1) {
            throw new DeploymentException("Missing host name!");
        }
        if (this.port < 0) {
            this.port = 5222;
        }
        if (this.participant == null && this.room == null || this.participant != null && this.room != null) {
            throw new DeploymentException("You have to define exactly one of the attributes 'room' and 'participant'!");
        }
    }

    public void start() throws Exception {
        super.start();
        if (this.proxyInfo == null && XMPPConstants.isSet(this.proxyHost)) {
            ProxyInfo.ProxyType pType = null;
            if (XMPPConstants.isSet(this.proxyType)) {
                pType = ProxyInfo.ProxyType.valueOf((String)this.proxyType.toUpperCase());
            }
            this.proxyInfo = new ProxyInfo(pType, this.proxyHost, XMPPConstants.isSet(this.proxyPort) ? Integer.parseInt(this.proxyPort) : 3128, this.proxyUser, this.proxyPass);
        }
        if (this.connectionConfig == null) {
            this.connectionConfig = this.proxyInfo != null ? new ConnectionConfiguration(this.host, this.port, this.proxyInfo) : new ConnectionConfiguration(this.host, this.port);
            this.connectionConfig.setCompressionEnabled(true);
            this.connectionConfig.setReconnectionAllowed(true);
            this.connectionConfig.setSASLAuthenticationEnabled(true);
        }
        if (this.connection == null) {
            this.connection = new XMPPConnection(this.connectionConfig);
            logger.debug("Connecting to server {}", (Object)this.host);
            this.connection.connect();
        }
        if (this.login && !this.connection.isAuthenticated()) {
            if (this.user != null) {
                logger.debug("Logging into Jabber as user: {} on connection: {}", (Object)this.user, (Object)this.connection);
                if (this.password == null) {
                    logger.warn("No password configured for user: {}", (Object)this.user);
                }
                if (this.createAccount) {
                    AccountManager accountManager = new AccountManager(this.connection);
                    accountManager.createAccount(this.user, this.password);
                }
                if (this.resource != null) {
                    this.connection.login(this.user, this.password, this.resource);
                } else {
                    this.connection.login(this.user, this.password);
                }
            } else {
                logger.debug("Logging in anonymously to Jabber on connection: {}", (Object)this.connection);
                this.connection.loginAnonymously();
            }
            this.connection.sendPacket((Packet)new Presence(Presence.Type.available));
        }
        if (this.connection != null && this.connection.isConnected()) {
            if (this.room != null) {
                this.chatRoom = new MultiUserChat(this.connection, this.room);
                this.chatRoom.join(this.user);
            } else if (this.participant != null) {
                this.userChat = this.connection.getChatManager().createChat(this.participant, null);
            }
        }
    }

    public void stop() throws Exception {
        if (this.connection != null && this.connection.isConnected()) {
            logger.debug("Disconnecting from server {}", (Object)this.host);
            this.connection.disconnect();
            this.connection = null;
        }
        super.stop();
    }

    protected void processInOnly(MessageExchange exchange, NormalizedMessage in) throws Exception {
        if (exchange.getStatus() != ExchangeStatus.DONE && exchange.getStatus() != ExchangeStatus.ERROR) {
            if (exchange.getFault() != null) {
                exchange.setStatus(ExchangeStatus.DONE);
                this.getChannel().send(exchange);
            } else {
                this.sendMessage(exchange, in);
            }
        }
    }

    protected void processInOut(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws Exception {
        if (exchange.getStatus() != ExchangeStatus.DONE && exchange.getStatus() != ExchangeStatus.ERROR) {
            if (exchange.getFault() != null) {
                exchange.setStatus(ExchangeStatus.DONE);
                this.getChannel().send(exchange);
            } else {
                this.sendMessage(exchange, in);
                MessageUtil.transferInToOut((MessageExchange)exchange, (MessageExchange)exchange);
                this.getChannel().send(exchange);
            }
        }
    }

    private void sendMessage(MessageExchange exchange, NormalizedMessage inMsg) throws Exception {
        Message message = null;
        if (this.participant != null) {
            message = new Message(this.participant, Message.Type.normal);
        } else {
            message = this.chatRoom.createMessage();
            message.setTo(this.room);
        }
        this.getMarshaler().fromJBI(message, exchange, inMsg);
        message.setFrom(this.user);
        if (this.participant != null) {
            this.userChat.sendMessage(message);
        } else {
            this.chatRoom.sendMessage(message);
        }
    }

    public XMPPMarshalerSupport getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(XMPPMarshalerSupport marshaler) {
        this.marshaler = marshaler;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPass() {
        return this.proxyPass;
    }

    public void setProxyPass(String proxyPass) {
        this.proxyPass = proxyPass;
    }

    public String getProxyType() {
        return this.proxyType;
    }

    public void setProxyType(String proxyType) {
        this.proxyType = proxyType;
    }

    public boolean isLogin() {
        return this.login;
    }

    public void setLogin(boolean login) {
        this.login = login;
    }

    public boolean isCreateAccount() {
        return this.createAccount;
    }

    public void setCreateAccount(boolean createAccount) {
        this.createAccount = createAccount;
    }

    public String getRoom() {
        return this.room;
    }

    public void setRoom(String room) {
        this.room = room;
    }

    public String getParticipant() {
        return this.participant;
    }

    public void setParticipant(String participant) {
        this.participant = participant;
    }
}

