/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.xmpp.marshaler.impl;

import java.util.Date;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.apache.servicemix.jbi.jaxp.SourceMarshaler;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.xmpp.marshaler.XMPPMarshalerSupport;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class DefaultXMPPMarshaler
implements XMPPMarshalerSupport {
    private SourceMarshaler sourceMarshaler;
    private static SourceTransformer st = new SourceTransformer();
    private String messageBodyTag = "message";
    private String messageBodyOpenTag = "<" + this.messageBodyTag + ">";
    private String messageBodyCloseTag = "</" + this.messageBodyTag + ">";
    public static final String FROM_PROPERTY = "xmpp.from";

    public DefaultXMPPMarshaler() {
        this(new SourceMarshaler());
    }

    public DefaultXMPPMarshaler(SourceMarshaler sourceMarshaler) {
        this.sourceMarshaler = sourceMarshaler;
    }

    public void fromJBI(Message message, MessageExchange exchange, NormalizedMessage normalizedMessage) throws TransformerException {
        try {
            Document doc = st.toDOMDocument(normalizedMessage);
            NodeList ls = doc.getElementsByTagName(this.getMessageBodyTag());
            if (ls == null || ls.getLength() <= 0) {
                throw new RuntimeException("Missing node for tag " + this.getMessageBodyTag());
            }
            String text = ls.item(0).getTextContent();
            message.setBody(text);
        }
        catch (Exception e) {
            String xml = this.messageAsString(normalizedMessage);
            message.setBody(xml);
        }
        this.addJabberProperties(message, exchange, normalizedMessage);
    }

    public void toJBI(NormalizedMessage normalizedMessage, Packet packet) throws MessagingException {
        this.addNmsProperties(normalizedMessage, packet);
        if (packet instanceof Message) {
            Message message = (Message)packet;
            String text = message.getBody();
            String from = message.getFrom();
            if (text != null) {
                StringSource stringSource = new StringSource(String.format("%s%s%s", this.messageBodyOpenTag, text, this.messageBodyCloseTag));
                normalizedMessage.setContent((Source)stringSource);
            }
            if (from != null) {
                normalizedMessage.setProperty(FROM_PROPERTY, (Object)from);
            }
        }
        normalizedMessage.setProperty("org.apache.servicemix.xmpp.packet", (Object)packet.toXML());
    }

    public SourceMarshaler getSourceMarshaler() {
        return this.sourceMarshaler;
    }

    public void setSourceMarshaler(SourceMarshaler sourceMarshaler) {
        this.sourceMarshaler = sourceMarshaler;
    }

    public String getMessageBodyTag() {
        return this.messageBodyTag;
    }

    public void setMessageBodyTag(String messageBodyTag) {
        this.messageBodyTag = messageBodyTag.replace("<", "").replace(">", "");
        this.messageBodyOpenTag = "<" + this.messageBodyTag + ">";
        this.messageBodyCloseTag = "</" + this.messageBodyTag + ">";
    }

    protected String messageAsString(NormalizedMessage normalizedMessage) throws TransformerException {
        return this.sourceMarshaler.asString(normalizedMessage.getContent());
    }

    protected void addJabberProperties(Message message, MessageExchange exchange, NormalizedMessage normalizedMessage) {
        for (Object o : normalizedMessage.getPropertyNames()) {
            Object value;
            String name = (String)o;
            if (!this.shouldIncludeHeader(normalizedMessage, name, value = normalizedMessage.getProperty(name))) continue;
            message.setProperty(name, value);
        }
        message.setProperty("exchangeId", (Object)exchange.getExchangeId());
        this.setProperty(message, "interface", exchange.getInterfaceName());
        this.setProperty(message, "operation", exchange.getOperation());
        this.setProperty(message, "service", exchange.getService());
        ServiceEndpoint endpoint = exchange.getEndpoint();
        if (endpoint != null) {
            message.setProperty("endpointName", (Object)endpoint.getEndpointName());
        }
    }

    protected void setProperty(Message message, String name, QName qName) {
        if (qName != null) {
            message.setProperty(name, (Object)qName.toString());
        }
    }

    protected void addNmsProperties(NormalizedMessage normalizedMessage, Packet message) {
        for (String name : message.getPropertyNames()) {
            Object value = message.getProperty(name);
            normalizedMessage.setProperty(name, value);
        }
    }

    protected boolean shouldIncludeHeader(NormalizedMessage normalizedMessage, String name, Object value) {
        return value instanceof String || value instanceof Number || value instanceof Date;
    }
}

