/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.maven.plugin.checksum;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class ChecksumValidatorMojo
extends AbstractMojo {
    static char[] hexTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    protected MavenProject project;
    protected List remoteArtifactRepositories;
    protected ArtifactRepository localRepository;
    protected ArtifactFactory artifactFactory;
    protected ArtifactResolver artifactResolver;
    protected File checksums;
    private String checksumAlgorithm;
    private boolean generate;
    private boolean includeDependencyArtifacts;
    private boolean includePluginArtifacts;
    private boolean includeReportArtifacts;

    protected String key(Artifact pom) {
        StringBuffer sb = new StringBuffer();
        sb.append(pom.getGroupId());
        sb.append("/");
        sb.append(pom.getArtifactId());
        sb.append("/");
        sb.append(pom.getType());
        sb.append("/");
        sb.append(pom.getVersion());
        return sb.toString();
    }

    protected String keyAnyVersion(Artifact pom) {
        StringBuffer sb = new StringBuffer();
        sb.append(pom.getGroupId());
        sb.append("/");
        sb.append(pom.getArtifactId());
        sb.append("/");
        sb.append(pom.getType());
        sb.append("/");
        sb.append("*");
        return sb.toString();
    }

    protected Artifact getPomArtifact(Artifact artifact) {
        return this.artifactFactory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
    }

    protected File resolve(Artifact artifact) throws MojoExecutionException {
        if (!artifact.isResolved()) {
            try {
                this.artifactResolver.resolve(artifact, this.remoteArtifactRepositories, this.localRepository);
            }
            catch (Throwable e) {
                throw new MojoExecutionException("Could not resolve the artifact for " + artifact + ": " + e.getMessage(), e);
            }
        }
        return artifact.getFile();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String checksum(File file) throws MojoExecutionException {
        try {
            MessageDigest md = MessageDigest.getInstance(this.checksumAlgorithm);
            FileInputStream is = null;
            try {
                int c;
                is = new FileInputStream(file);
                byte[] buffer = new byte[4096];
                while ((c = is.read(buffer)) >= 0) {
                    md.update(buffer, 0, c);
                }
                byte[] digest = md.digest();
                String string = ChecksumValidatorMojo.toString(digest);
                return string;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could read file: " + this.checksums);
            }
            finally {
                try {
                    is.close();
                }
                catch (Throwable e) {}
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new MojoExecutionException("Invalid checksum algorithm: " + this.checksumAlgorithm, (Exception)e);
        }
    }

    static String toString(byte[] digest) {
        StringBuilder rc = new StringBuilder(digest.length * 2);
        for (int i = 0; i < digest.length; ++i) {
            rc.append(hexTable[digest[i] >> 4 & 0xF]);
            rc.append(hexTable[digest[i] & 0xF]);
        }
        return rc.toString();
    }

    public void execute() throws MojoExecutionException {
        if (this.generate) {
            this.generate();
        } else {
            this.validate();
        }
    }

    private void validate() throws MojoExecutionException {
        LinkedHashMap checksums = this.loadChecksums();
        boolean failed = false;
        Iterator it = this.getArtifacts().iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            Artifact pom = this.getPomArtifact(artifact);
            failed |= this.validateArtifact(checksums, pom);
            failed |= this.validateArtifact(checksums, artifact);
        }
        if (failed) {
            throw new MojoExecutionException("Invalid checksum(s) found.. see previous error messages for more details.");
        }
    }

    private boolean validateArtifact(LinkedHashMap checksums, Artifact artifact) throws MojoExecutionException {
        File file = this.resolve(artifact);
        String sum = this.checksum(file);
        String key = this.key(artifact);
        List list = (List)checksums.get(key);
        if (list == null) {
            list = (List)checksums.get(this.keyAnyVersion(artifact));
        }
        if (list == null) {
            this.getLog().error((CharSequence)("No checksum specified for " + key + " in " + this.checksums + " (" + sum + ")"));
            return true;
        }
        if (!list.contains(sum) && !list.contains("*")) {
            this.getLog().error((CharSequence)("Checksum mismatch for " + key + " in " + this.checksums + " expected one of " + list + " but was " + sum));
            return true;
        }
        return false;
    }

    public void generate() throws MojoExecutionException {
        LinkedHashMap checksums = new LinkedHashMap();
        boolean modified = true;
        try {
            checksums = this.loadChecksums();
            modified = false;
        }
        catch (MojoExecutionException e) {
            // empty catch block
        }
        Iterator it = this.getArtifacts().iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            Artifact pom = this.getPomArtifact(artifact);
            modified |= this.generateArtifact(checksums, pom);
            modified |= this.generateArtifact(checksums, artifact);
        }
        if (modified) {
            this.storeChecksums(checksums);
        }
    }

    private Set getArtifacts() {
        HashSet rc = new HashSet();
        if (this.includeDependencyArtifacts) {
            rc.addAll(this.project.getDependencyArtifacts());
        }
        if (this.includePluginArtifacts) {
            rc.addAll(this.project.getPluginArtifacts());
        }
        if (this.includeReportArtifacts) {
            rc.addAll(this.project.getReportArtifacts());
        }
        return rc;
    }

    private boolean generateArtifact(HashMap checksums, Artifact artifact) throws MojoExecutionException {
        File file = this.resolve(artifact);
        String sum = this.checksum(file);
        List<String> sums = (ArrayList)checksums.get(this.key(artifact));
        if (sums == null) {
            sums = (List)checksums.get(this.keyAnyVersion(artifact));
        }
        if (sums == null) {
            sums = new ArrayList();
            sums.add(sum);
            checksums.put(this.key(artifact), sums);
            return true;
        }
        if (!sums.contains(sum) && !sums.contains("*")) {
            sums.add(sum);
            return true;
        }
        return false;
    }

    protected LinkedHashMap loadChecksums() throws MojoExecutionException {
        LinkedHashMap rc = new LinkedHashMap();
        if (!this.checksums.canRead()) {
            throw new MojoExecutionException("Cannot read checksum file: " + this.checksums);
        }
        InputStream is = null;
        try {
            String[] line;
            is = new FileInputStream(this.checksums);
            CSVReader reader = new CSVReader((Reader)new InputStreamReader(is, "UTF-8"), '=');
            while ((line = reader.readNext()) != null) {
                if (line.length <= 0) continue;
                String key = line[0].trim();
                ArrayList<String> values = new ArrayList<String>(2);
                if (line.length > 1) {
                    String[] t = line[1].split("\\|");
                    for (int j = 0; j < t.length; ++j) {
                        values.add(t[j].toLowerCase().trim());
                    }
                }
                rc.put(key, values);
            }
            reader.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not load checksum file: " + this.checksums);
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable e) {}
        }
        return rc;
    }

    private void storeChecksums(LinkedHashMap checksums) throws MojoExecutionException {
        FileOutputStream os = null;
        try {
            boolean exists = this.checksums.exists();
            os = new FileOutputStream(this.checksums);
            CSVWriter writer = new CSVWriter((Writer)new OutputStreamWriter((OutputStream)os, "UTF-8"), '=', '\u0000');
            if (!exists) {
                writer.writeNext(new String[]{"# This file uses a 'property file like' syntax"});
                writer.writeNext(new String[]{"# Entries are in the following format: 'artifact", "checksum-1|...|checksum-n'"});
                writer.writeNext(new String[]{"# Where artifact follows the following format: 'group/id/type/version'"});
                writer.writeNext(new String[]{"# You can use '*' for the version or checksum"});
                writer.writeNext(new String[]{""});
            }
            Iterator iterator = checksums.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry i = iterator.next();
                StringBuffer b = new StringBuffer();
                Iterator iterator2 = ((List)i.getValue()).iterator();
                while (iterator2.hasNext()) {
                    String s = (String)iterator2.next();
                    if (b.length() != 0) {
                        b.append("|");
                    }
                    b.append(s);
                }
                String key = (String)i.getKey();
                String value = b.toString();
                if (value.length() != 0) {
                    writer.writeNext(new String[]{key, value});
                    continue;
                }
                writer.writeNext(new String[]{key});
            }
            writer.close();
        }
        catch (Throwable e) {
            throw new MojoExecutionException("Could not write: " + this.checksums);
        }
        finally {
            try {
                os.close();
            }
            catch (Throwable ignore) {}
        }
    }
}

