/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.maven.plugin.jbi;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.servicemix.jbi.container.SpringJBIContainer;
import org.apache.servicemix.maven.plugin.jbi.AbstractJbiMojo;
import org.apache.xbean.spring.context.FileSystemXmlApplicationContext;
import org.springframework.beans.factory.DisposableBean;

public class ServiceMixEmbeddedMojo
extends AbstractJbiMojo {
    private File servicemixConfig;
    private FileSystemXmlApplicationContext context;
    private SpringJBIContainer container;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.startServiceMix();
            Object lock = new Object();
            this.container.setShutdownLock(lock);
            Object object = lock;
            synchronized (object) {
                lock.wait();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Apache ServiceMix was able to deploy project", e);
        }
        finally {
            if (this.context instanceof DisposableBean) {
                try {
                    this.context.destroy();
                }
                catch (Exception e) {}
            }
        }
    }

    private void startServiceMix() throws MojoExecutionException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClassLoader());
            this.context = new FileSystemXmlApplicationContext("file:///" + this.servicemixConfig.getAbsolutePath());
            this.container = (SpringJBIContainer)this.context.getBean("jbi");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to start the ServiceMix container", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }
}

