/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.maven.plugin.jbi;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.servicemix.maven.plugin.jbi.JbiProjectDeployerMojo;
import org.codehaus.plexus.util.FileUtils;

public class MakeServiceMixDirsMojo
extends JbiProjectDeployerMojo {
    private String deployDirectory;
    private boolean cleanStart;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (this.cleanStart) {
                this.getLog().info((CharSequence)("Cleaning ServiceMix root directory [" + this.deployDirectory + "]"));
                File rootDir = new File(this.deployDirectory);
                FileUtils.deleteDirectory((File)rootDir);
                rootDir.mkdirs();
            }
            this.deployProject();
            this.getLog().info((CharSequence)"Project deployed");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Apache ServiceMix was unable to deploy project", e);
        }
    }

    protected void deployDependency(JbiProjectDeployerMojo.JbiDeployableArtifact jbiDeployable, boolean doDeferExceptions) throws MojoExecutionException {
        String name = jbiDeployable.getType();
        this.getLog().info((CharSequence)("deployDependency: type: " + name + " dependency: " + jbiDeployable));
        if ("jbi-service-assembly".equals(name)) {
            File assemblyFile = new File(jbiDeployable.getFile());
            File outputFile = new File(this.deployDirectory, assemblyFile.getName());
            this.getLog().info((CharSequence)("copying service Assembly!:  " + jbiDeployable + " to: " + outputFile));
            try {
                FileUtils.copyFile((File)assemblyFile, (File)outputFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
    }

    protected void startDependency(JbiProjectDeployerMojo.JbiDeployableArtifact jbiDeployable) {
    }

    protected void stopDependency(JbiProjectDeployerMojo.JbiDeployableArtifact jbiDeployable) {
    }

    protected boolean isDeployed(JbiProjectDeployerMojo.JbiDeployableArtifact jbiDeployable) {
        return false;
    }
}

