/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.maven.plugin.jbi;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.logging.Log;

public class JbiResolutionListener
implements ResolutionListener {
    private Stack parents = new Stack();
    private Map artifacts = new HashMap();
    private Node rootNode;
    private Log log;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void setLog(Log log) {
        this.log = log;
    }

    public Log getLog() {
        return this.log;
    }

    public void testArtifact(Artifact artifact) {
    }

    public void startProcessChildren(Artifact artifact) {
        Node node = (Node)this.artifacts.get(artifact.getDependencyConflictId());
        if (this.parents.isEmpty()) {
            this.rootNode = node;
        }
        this.parents.push(node);
    }

    public void endProcessChildren(Artifact artifact) {
        Node check = (Node)this.parents.pop();
        if (!$assertionsDisabled && !artifact.equals(check.artifact)) {
            throw new AssertionError();
        }
    }

    public void omitForNearer(Artifact omitted, Artifact kept) {
        if (!$assertionsDisabled && !omitted.getDependencyConflictId().equals(kept.getDependencyConflictId())) {
            throw new AssertionError();
        }
        Node node = (Node)this.artifacts.get(omitted.getDependencyConflictId());
        if (!$assertionsDisabled && node == null) {
            throw new AssertionError();
        }
        node.artifact = kept;
    }

    public void omitForCycle(Artifact artifact) {
    }

    public void includeArtifact(Artifact artifact) {
        Node node = (Node)this.artifacts.get(artifact.getDependencyConflictId());
        if (node == null) {
            node = new Node();
            this.artifacts.put(artifact.getDependencyConflictId(), node);
        }
        node.artifact = artifact;
        if (!this.parents.isEmpty()) {
            Node parent = (Node)this.parents.peek();
            parent.children.add(node);
            node.parents.add(parent);
        }
        if (this.rootNode != null) {
            // empty if block
        }
    }

    protected void print(Node node, String string) {
        Iterator iter = node.getChildren().iterator();
        while (iter.hasNext()) {
            Node n = (Node)iter.next();
            this.print(n, string + "  ");
        }
    }

    public void updateScope(Artifact artifact, String scope) {
        Node node = (Node)this.artifacts.get(artifact.getDependencyConflictId());
        node.artifact.setScope(scope);
    }

    public void manageArtifact(Artifact artifact, Artifact replacement) {
        Node node = (Node)this.artifacts.get(artifact.getDependencyConflictId());
        if (node != null) {
            if (replacement.getVersion() != null) {
                node.artifact.setVersion(replacement.getVersion());
            }
            if (replacement.getScope() != null) {
                node.artifact.setScope(replacement.getScope());
            }
        }
    }

    public void updateScopeCurrentPom(Artifact artifact, String key) {
        this.getLog().debug((CharSequence)("updateScopeCurrentPom: " + artifact));
    }

    public void selectVersionFromRange(Artifact artifact) {
        this.getLog().debug((CharSequence)("selectVersionFromRange: " + artifact));
    }

    public void restrictRange(Artifact artifact, Artifact artifact1, VersionRange versionRange) {
        this.getLog().debug((CharSequence)("restrictRange: " + artifact));
    }

    public Node getNode(Artifact artifact) {
        return (Node)this.artifacts.get(artifact.getDependencyConflictId());
    }

    public Collection getArtifacts() {
        return this.artifacts.values();
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    static {
        $assertionsDisabled = !JbiResolutionListener.class.desiredAssertionStatus();
    }

    static class Node {
        private Set children = new HashSet();
        private Set parents = new HashSet();
        private Artifact artifact;

        Node() {
        }

        public Set getChildren() {
            return this.children;
        }

        public Artifact getArtifact() {
            return this.artifact;
        }

        public Set getParents() {
            return this.parents;
        }
    }
}

