/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.maven.plugin.jbi;

import java.io.File;
import javax.jbi.JBIException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.maven.plugin.jbi.JbiProjectDeployerMojo;
import org.codehaus.plexus.util.FileUtils;

public class ServiceMixMojo
extends JbiProjectDeployerMojo {
    private JBIContainer jbiContainer;
    private String installDirectory;
    private String deploymentDirectory;
    private String rootDirectory;
    private boolean cleanStart;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (this.cleanStart) {
                this.getLog().info((CharSequence)("Cleaning ServiceMix root directory [" + this.rootDirectory + "]"));
                File rootDir = new File(this.rootDirectory);
                FileUtils.deleteDirectory((File)rootDir);
                rootDir.mkdirs();
            }
            this.startServiceMix();
            this.deployProject();
            this.getLog().info((CharSequence)"Project deployed");
            while (true) {
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            this.stopServiceMix();
            throw new MojoExecutionException("Apache ServiceMix was unable to deploy project", e);
        }
    }

    private void stopServiceMix() {
        this.getLog().info((CharSequence)"Shutting down Apache ServiceMix");
        if (this.jbiContainer != null) {
            try {
                this.jbiContainer.shutDown();
            }
            catch (JBIException e) {
                this.getLog().warn((Throwable)e);
            }
        }
    }

    private void startServiceMix() throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)"Starting Apache ServiceMix");
            this.jbiContainer = new JBIContainer();
            this.jbiContainer.setRmiPort(Integer.parseInt(this.port));
            this.jbiContainer.setCreateMBeanServer(true);
            this.jbiContainer.setInstallationDirPath(this.installDirectory);
            this.jbiContainer.setDeploymentDirPath(this.deploymentDirectory);
            this.jbiContainer.setRootDir(this.rootDirectory);
            this.jbiContainer.init();
            this.jbiContainer.start();
        }
        catch (JBIException e) {
            throw new MojoExecutionException("Unable to start the JBI container", (Exception)((Object)e));
        }
    }
}

