/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.maven.plugin.jbi;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.servicemix.maven.plugin.jbi.AbstractJbiMojo;
import org.apache.servicemix.maven.plugin.jbi.JbiPluginException;
import org.apache.servicemix.maven.plugin.jbi.JbiResolutionListener;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.util.FileUtils;

public class GenerateServiceUnitMojo
extends AbstractJbiMojo {
    private String serviceUnitName;
    private File outputDirectory;
    private JarArchiver jarArchiver;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private File serviceUnitLocation;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.createUnpackedInstaller();
            File serviceUnitFile = new File(this.outputDirectory, this.serviceUnitName);
            this.createArchive(serviceUnitFile);
            this.projectHelper.attachArtifact(this.project, "zip", "", new File(this.outputDirectory, this.serviceUnitName));
        }
        catch (JbiPluginException e) {
            throw new MojoExecutionException("Failed to create service unit", (Exception)e);
        }
    }

    private void createArchive(File installerFile) throws JbiPluginException {
        try {
            this.getLog().info((CharSequence)("Generating service unit " + installerFile.getAbsolutePath()));
            MavenArchiver archiver = new MavenArchiver();
            archiver.setArchiver(this.jarArchiver);
            archiver.setOutputFile(installerFile);
            this.jarArchiver.addDirectory(this.workDirectory);
            archiver.createArchive(this.getProject(), this.archive);
        }
        catch (ArchiverException e) {
            throw new JbiPluginException("Error creating service unit: " + e.getMessage(), e);
        }
        catch (ManifestException e) {
            throw new JbiPluginException("Error creating service unit: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new JbiPluginException("Error creating service unit: " + e.getMessage(), e);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new JbiPluginException("Error creating service unit: " + e.getMessage(), e);
        }
    }

    private void createUnpackedInstaller() throws JbiPluginException {
        Artifact artifact;
        if (!this.workDirectory.isDirectory() && !this.workDirectory.mkdirs()) {
            throw new JbiPluginException("Unable to create work directory: " + this.workDirectory);
        }
        try {
            FileUtils.copyDirectoryStructure((File)this.serviceUnitLocation, (File)this.workDirectory);
        }
        catch (IOException e) {
            throw new JbiPluginException("Unable to copy directory " + this.serviceUnitLocation, e);
        }
        ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
        JbiResolutionListener listener = this.resolveProject();
        HashSet<Artifact> includes = new HashSet<Artifact>();
        Iterator iter = this.project.getArtifacts().iterator();
        while (iter.hasNext()) {
            String type;
            artifact = (Artifact)iter.next();
            if (artifact.isOptional() || !filter.include(artifact)) continue;
            MavenProject project = null;
            this.getLog().info((CharSequence)("Resolving " + artifact));
            try {
                project = this.projectBuilder.buildFromRepository(artifact, this.remoteRepos, this.localRepo);
            }
            catch (ProjectBuildingException e) {
                this.getLog().warn((CharSequence)("Unable to determine packaging for dependency : " + artifact.getArtifactId() + " assuming jar"));
            }
            String string = type = project != null ? project.getPackaging() : artifact.getType();
            if ("jbi-component".equals(type)) {
                this.removeBranch(listener, artifact);
                continue;
            }
            if ("jbi-shared-library".equals(type)) {
                this.removeBranch(listener, artifact);
                continue;
            }
            includes.add(artifact);
        }
        iter = this.retainArtifacts(includes, listener).iterator();
        while (iter.hasNext()) {
            artifact = (Artifact)iter.next();
            try {
                this.getLog().info((CharSequence)("Including: " + artifact));
                FileUtils.copyFileToDirectory((File)artifact.getFile(), (File)new File(this.workDirectory, "lib"));
            }
            catch (IOException e) {
                throw new JbiPluginException("Unable to copy file " + artifact.getFile(), e);
            }
        }
    }
}

