/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.maven.plugin.jbi;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.servicemix.maven.plugin.jbi.AbstractJbiMojo;
import org.apache.xbean.spring.context.FileSystemXmlApplicationContext;
import org.springframework.beans.factory.DisposableBean;

public class ServiceMixEmbeddedMojo
extends AbstractJbiMojo {
    private File servicemixConfig;
    private FileSystemXmlApplicationContext context;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            try {
                this.startServiceMix();
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                throw new MojoFailureException("Interrupted");
            }
        }
        catch (Throwable throwable) {
            if (this.context instanceof DisposableBean) {
                try {
                    this.context.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw throwable;
        }
    }

    private void startServiceMix() throws MojoExecutionException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClassLoader());
            this.context = new FileSystemXmlApplicationContext("file:///" + this.servicemixConfig.getAbsolutePath());
            this.context.getBean("jbi");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to start the ServiceMix container", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }
}

