/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.maven.plugin.jbi;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.servicemix.maven.plugin.jbi.AbstractJbiMojo;
import org.apache.servicemix.maven.plugin.jbi.JbiPluginException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public class GenerateServiceAssemblyMojo
extends AbstractJbiMojo {
    private JarArchiver jarArchiver;
    private File outputDirectory;
    private String finalName;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.injectDependentServiceUnits();
            this.createArchive(new File(this.outputDirectory, this.finalName));
            this.projectHelper.attachArtifact(this.project, "zip", null, new File(this.outputDirectory, this.finalName));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to inject dependencies", e);
        }
    }

    private void createArchive(File installerFile) throws JbiPluginException {
        try {
            this.getLog().info((CharSequence)("Generating service assembly " + installerFile.getAbsolutePath()));
            MavenArchiver archiver = new MavenArchiver();
            archiver.setArchiver(this.jarArchiver);
            archiver.setOutputFile(installerFile);
            this.jarArchiver.addConfiguredManifest(this.createManifest());
            this.jarArchiver.addDirectory(this.workDirectory, null, DirectoryScanner.DEFAULTEXCLUDES);
            archiver.createArchive(this.getProject(), this.archive);
        }
        catch (Exception e) {
            throw new JbiPluginException("Error creating shared library: " + e.getMessage(), e);
        }
    }

    private void injectDependentServiceUnits() throws JbiPluginException, ArtifactResolutionException, ArtifactNotFoundException {
        Set artifacts = this.project.getArtifacts();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
            if (artifact.isOptional() || !filter.include(artifact) || artifact.getDependencyTrail().size() != 2) continue;
            MavenProject project = null;
            try {
                project = this.projectBuilder.buildFromRepository(artifact, this.remoteRepos, this.localRepo);
            }
            catch (ProjectBuildingException e) {
                this.getLog().warn((CharSequence)("Unable to determine packaging for dependency : " + artifact.getArtifactId() + " assuming jar"));
            }
            if (project == null || !project.getPackaging().equals("jbi-service-unit")) continue;
            try {
                String path = artifact.getFile().getAbsolutePath();
                path = path.substring(0, path.lastIndexOf(46)) + ".zip";
                FileUtils.copyFileToDirectory((File)new File(path), (File)this.workDirectory);
            }
            catch (IOException e) {
                throw new JbiPluginException(e);
            }
        }
    }
}

