/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.maven.plugin.jbi;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.servicemix.maven.plugin.jbi.AbstractJbiMojo;
import org.apache.servicemix.maven.plugin.jbi.JbiPluginException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public class GenerateSharedLibraryMojo
extends AbstractJbiMojo {
    private File outputDirectory;
    private String sharedLibraryName;
    private String jarName;
    private JarArchiver jarArchiver;
    private File jbiSourceDirectory;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)" ======= GenerateInstallerMojo settings =======");
        this.getLog().debug((CharSequence)("workDirectory[" + this.workDirectory + "]"));
        this.getLog().debug((CharSequence)("installerName[" + this.sharedLibraryName + "]"));
        this.getLog().debug((CharSequence)("jbiSourceDirectory[" + this.jbiSourceDirectory + "]"));
        try {
            this.createUnpackedSharedLibrary();
            File installerFile = new File(this.outputDirectory, this.sharedLibraryName);
            this.createArchive(installerFile);
            this.projectHelper.attachArtifact(this.project, "jar", "", new File(this.outputDirectory, this.jarName));
            this.projectHelper.attachArtifact(this.project, "zip", "installer", new File(this.outputDirectory, this.sharedLibraryName));
        }
        catch (JbiPluginException e) {
            throw new MojoExecutionException("Failed to create shared library", (Exception)e);
        }
    }

    private void createArchive(File installerFile) throws JbiPluginException {
        try {
            this.getLog().info((CharSequence)("Generating shared library " + installerFile.getAbsolutePath()));
            MavenArchiver archiver = new MavenArchiver();
            archiver.setArchiver(this.jarArchiver);
            archiver.setOutputFile(installerFile);
            this.jarArchiver.addDirectory(this.workDirectory);
            this.jarArchiver.addConfiguredManifest(this.createManifest());
            if (this.jbiSourceDirectory.isDirectory()) {
                this.jarArchiver.addDirectory(this.jbiSourceDirectory, null, DirectoryScanner.DEFAULTEXCLUDES);
            }
            archiver.createArchive(this.getProject(), this.archive);
        }
        catch (Exception e) {
            throw new JbiPluginException("Error creating shared library: " + e.getMessage(), e);
        }
    }

    private void createUnpackedSharedLibrary() throws JbiPluginException {
        if (!this.workDirectory.isDirectory() && !this.workDirectory.mkdirs()) {
            throw new JbiPluginException("Unable to create work directory: " + this.workDirectory);
        }
        File projectArtifact = new File(this.outputDirectory, this.project.getArtifactId() + "-" + this.project.getVersion() + ".jar");
        try {
            FileUtils.copyFileToDirectory((File)projectArtifact, (File)new File(this.workDirectory, "lib"));
        }
        catch (IOException e) {
            throw new JbiPluginException("Unable to copy file " + projectArtifact, e);
        }
        Set artifacts = this.project.getArtifacts();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            String type;
            Artifact artifact = (Artifact)iter.next();
            ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
            if (artifact.isOptional() || !filter.include(artifact) || !"jar".equals(type = artifact.getType())) continue;
            try {
                FileUtils.copyFileToDirectory((File)artifact.getFile(), (File)new File(this.workDirectory, "lib"));
            }
            catch (IOException e) {
                throw new JbiPluginException("Unable to copy file " + artifact.getFile(), e);
            }
        }
    }
}

