/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.maven.plugin.jbi;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.packaging.Consumes;
import org.apache.servicemix.common.packaging.Provides;
import org.codehaus.plexus.util.xml.XMLWriter;

public class AbstractDescriptorWriter {
    protected void addStringAttribute(XMLWriter writer, String attributeName, String attributeValue) {
        if (attributeValue != null) {
            writer.addAttribute(attributeName, attributeValue);
        }
    }

    protected void addQNameAttribute(XMLWriter writer, String attributeName, QName attributeValue, Map namespaceMap) {
        if (attributeValue != null) {
            StringBuffer attributeStringValue = new StringBuffer();
            attributeStringValue.append(namespaceMap.get(attributeValue.getNamespaceURI()));
            attributeStringValue.append(":");
            attributeStringValue.append(attributeValue.getLocalPart());
            writer.addAttribute(attributeName, attributeStringValue.toString());
        }
    }

    protected Map getNamespaceMap(List provides, List consumes) {
        HashMap namespaceMap = new HashMap();
        int namespaceCounter = 1;
        for (Provides providesEntry : provides) {
            namespaceCounter = this.resolveMapEntry(namespaceMap, providesEntry.getInterfaceName(), namespaceCounter);
            namespaceCounter = this.resolveMapEntry(namespaceMap, providesEntry.getServiceName(), namespaceCounter);
        }
        for (Consumes consumesEntry : consumes) {
            namespaceCounter = this.resolveMapEntry(namespaceMap, consumesEntry.getInterfaceName(), namespaceCounter);
            namespaceCounter = this.resolveMapEntry(namespaceMap, consumesEntry.getServiceName(), namespaceCounter);
        }
        return namespaceMap;
    }

    private int resolveMapEntry(Map namespaceMap, QName qname, int namespaceCounter) {
        if (qname != null && !namespaceMap.containsKey(qname.getNamespaceURI())) {
            if (qname.getPrefix() == null || qname.getPrefix().equals("")) {
                namespaceMap.put(qname.getNamespaceURI(), "ns" + namespaceCounter++);
            } else {
                namespaceMap.put(qname.getNamespaceURI(), qname.getPrefix());
            }
        }
        return namespaceCounter;
    }
}

