/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.maven.plugin.jbi;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import org.apache.servicemix.maven.plugin.jbi.DependencyInformation;
import org.apache.servicemix.maven.plugin.jbi.JbiPluginException;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;

public class JbiComponentDescriptorWriter {
    private final String encoding;

    public JbiComponentDescriptorWriter(String encoding) {
        this.encoding = encoding;
    }

    public void write(File descriptor, String component, String bootstrap, String type, String name, String description, String componentClassLoaderDelegation, String bootstrapClassLoaderDelegation, List uris) throws JbiPluginException {
        PrintWriter w;
        try {
            w = new PrintWriter(descriptor, this.encoding);
        }
        catch (IOException ex) {
            throw new JbiPluginException("Exception while opening file[" + descriptor.getAbsolutePath() + "]", ex);
        }
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter(w, this.encoding, null);
        writer.startElement("jbi");
        writer.addAttribute("xmlns", "http://java.sun.com/xml/ns/jbi");
        writer.addAttribute("version", "1.0");
        writer.startElement("component");
        writer.addAttribute("type", type);
        writer.addAttribute("component-class-loader-delegation", componentClassLoaderDelegation);
        writer.addAttribute("bootstrap-class-loader-delegation", bootstrapClassLoaderDelegation);
        writer.startElement("identification");
        writer.startElement("name");
        writer.writeText(name);
        writer.endElement();
        writer.startElement("description");
        writer.writeText(description);
        writer.endElement();
        writer.endElement();
        writer.startElement("component-class-name");
        writer.writeText(component);
        writer.endElement();
        writer.startElement("component-class-path");
        for (DependencyInformation info : uris) {
            if (!"jar".equals(info.getType()) && !"bundle".equals(info.getType()) && !"jbi-component".equals(info.getType())) continue;
            writer.startElement("path-element");
            writer.writeText(info.getFilename());
            writer.endElement();
        }
        writer.endElement();
        writer.startElement("bootstrap-class-name");
        writer.writeText(bootstrap);
        writer.endElement();
        writer.startElement("bootstrap-class-path");
        for (DependencyInformation info : uris) {
            if (!"jar".equals(info.getType())) continue;
            writer.startElement("path-element");
            writer.writeText(info.getFilename());
            writer.endElement();
        }
        writer.endElement();
        for (DependencyInformation info : uris) {
            if (!"jbi-shared-library".equals(info.getType())) continue;
            writer.startElement("shared-library");
            writer.addAttribute("version", info.getVersion());
            writer.writeText(info.getName());
            writer.endElement();
        }
        writer.endElement();
        writer.endElement();
        this.close(w);
    }

    private void close(Writer closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

