/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.maven.plugin.jbi;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.servicemix.common.packaging.Consumes;
import org.apache.servicemix.common.packaging.Provides;
import org.apache.servicemix.maven.plugin.jbi.AbstractDescriptorWriter;
import org.apache.servicemix.maven.plugin.jbi.JbiPluginException;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class JbiServiceUnitDescriptorWriter
extends AbstractDescriptorWriter {
    private final String encoding;

    public JbiServiceUnitDescriptorWriter(String encoding) {
        this.encoding = encoding;
    }

    public void write(File descriptor, boolean bc, String name, String description, List uris, List consumes, List provides) throws JbiPluginException {
        PrintWriter w;
        try {
            w = new PrintWriter(descriptor, this.encoding);
        }
        catch (IOException ex) {
            throw new JbiPluginException("Exception while opening file[" + descriptor.getAbsolutePath() + "]", ex);
        }
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter(w, this.encoding, null);
        writer.startElement("jbi");
        writer.addAttribute("xmlns", "http://java.sun.com/xml/ns/jbi");
        writer.addAttribute("version", "1.0");
        writer.startElement("services");
        writer.addAttribute("binding-component", bc ? "true" : "false");
        Map namespaceMap = this.getNamespaceMap(provides, consumes);
        for (String key : namespaceMap.keySet()) {
            StringBuffer namespaceDecl = new StringBuffer();
            namespaceDecl.append("xmlns:");
            namespaceDecl.append(namespaceMap.get(key));
            writer.addAttribute(namespaceDecl.toString(), key);
        }
        for (Provides providesEntry : provides) {
            writer.startElement("provides");
            this.addQNameAttribute((XMLWriter)writer, "interface-name", providesEntry.getInterfaceName(), namespaceMap);
            this.addQNameAttribute((XMLWriter)writer, "service-name", providesEntry.getServiceName(), namespaceMap);
            this.addStringAttribute((XMLWriter)writer, "endpoint-name", providesEntry.getEndpointName());
            writer.endElement();
        }
        for (Consumes consumesEntry : consumes) {
            writer.startElement("consumes");
            this.addQNameAttribute((XMLWriter)writer, "interface-name", consumesEntry.getInterfaceName(), namespaceMap);
            this.addQNameAttribute((XMLWriter)writer, "service-name", consumesEntry.getServiceName(), namespaceMap);
            this.addStringAttribute((XMLWriter)writer, "endpoint-name", consumesEntry.getEndpointName());
            writer.endElement();
        }
        writer.endElement();
        writer.endElement();
        this.close(w);
    }

    private void close(Writer closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

