/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.maven.plugin.jbi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.servicemix.maven.plugin.jbi.AbstractJbiMojo;

public class GenerateDependsFileMojo
extends AbstractJbiMojo {
    protected static final String SEPARATOR = "/";
    private File outputFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        OutputStream out = null;
        try {
            this.outputFile.getParentFile().mkdirs();
            out = new FileOutputStream(this.outputFile);
            PrintStream printer = new PrintStream(out);
            this.populateProperties(printer);
            this.getLog().info((CharSequence)("Created: " + this.outputFile));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to create dependencies file: " + e, e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.getLog().info((CharSequence)("Failed to close: " + this.outputFile + ". Reason: " + e), (Throwable)e);
                }
            }
        }
    }

    protected void populateProperties(PrintStream out) {
        out.println("# Project dependencies generated by the Apache ServiceMix Maven Plugin");
        out.println("# Generated at: " + new Date());
        out.println();
        out.println("groupId = " + this.project.getGroupId());
        out.println("artifactId = " + this.project.getArtifactId());
        out.println("version = " + this.project.getVersion());
        out.println(this.project.getGroupId() + SEPARATOR + this.project.getArtifactId() + SEPARATOR + "version = " + this.project.getVersion());
        out.println();
        out.println("# dependencies");
        out.println();
        for (Dependency dependency : this.project.getDependencies()) {
            String prefix = dependency.getGroupId() + SEPARATOR + dependency.getArtifactId() + SEPARATOR;
            out.println(prefix + "version = " + dependency.getVersion());
            String classifier = dependency.getClassifier();
            if (classifier != null) {
                out.println(prefix + "classifier = " + classifier);
            }
            out.println(prefix + "type = " + dependency.getType());
            out.println(prefix + "scope = " + dependency.getScope());
            out.println();
            this.getLog().debug((CharSequence)("Dependency: " + dependency + " classifier: " + classifier + " type: " + dependency.getType()));
        }
    }
}

