/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.maven.plugin.jbi;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.servicemix.common.packaging.Consumes;
import org.apache.servicemix.common.packaging.Provides;
import org.apache.servicemix.maven.plugin.jbi.AbstractDescriptorWriter;
import org.apache.servicemix.maven.plugin.jbi.DependencyInformation;
import org.apache.servicemix.maven.plugin.jbi.GenerateServiceAssemblyDescriptorMojo;
import org.apache.servicemix.maven.plugin.jbi.JbiPluginException;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class JbiServiceAssemblyDescriptorWriter
extends AbstractDescriptorWriter {
    private final String encoding;

    public JbiServiceAssemblyDescriptorWriter(String encoding) {
        this.encoding = encoding;
    }

    public void write(File descriptor, String name, String description, List uris, List connections) throws JbiPluginException {
        PrintWriter w;
        try {
            w = new PrintWriter(descriptor, this.encoding);
        }
        catch (IOException ex) {
            throw new JbiPluginException("Exception while opening file[" + descriptor.getAbsolutePath() + "]", ex);
        }
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter(w, this.encoding, null);
        writer.startElement("jbi");
        writer.addAttribute("xmlns", "http://java.sun.com/xml/ns/jbi");
        writer.addAttribute("version", "1.0");
        writer.startElement("service-assembly");
        writer.startElement("identification");
        writer.startElement("name");
        writer.writeText(name);
        writer.endElement();
        writer.startElement("description");
        writer.writeText(description);
        writer.endElement();
        writer.endElement();
        for (DependencyInformation serviceUnitInfo : uris) {
            this.writeServiceUnit((XMLWriter)writer, serviceUnitInfo);
        }
        if (!connections.isEmpty()) {
            writer.startElement("connections");
            Map namespaceMap = this.buildNamespaceMap(connections);
            for (GenerateServiceAssemblyDescriptorMojo.Connection connection : connections) {
                this.writeConnection(namespaceMap, (XMLWriter)writer, connection);
            }
            writer.endElement();
        }
        writer.endElement();
        writer.endElement();
        this.close(w);
    }

    private Map buildNamespaceMap(List connections) {
        ArrayList<Consumes> consumes = new ArrayList<Consumes>();
        ArrayList<Provides> provides = new ArrayList<Provides>();
        for (GenerateServiceAssemblyDescriptorMojo.Connection connection : connections) {
            consumes.add(connection.getConsumes());
            provides.add(connection.getProvides());
        }
        return this.getNamespaceMap(provides, consumes);
    }

    private void writeConnection(Map namespaceMap, XMLWriter writer, GenerateServiceAssemblyDescriptorMojo.Connection connection) {
        writer.startElement("connection");
        if (connection.getConsumes() != null) {
            writer.startElement("consumer");
            this.addQNameAttribute(writer, "interface-name", connection.getConsumes().getInterfaceName(), namespaceMap);
            this.addQNameAttribute(writer, "service-name", connection.getConsumes().getServiceName(), namespaceMap);
            this.addStringAttribute(writer, "endpoint-name", connection.getConsumes().getEndpointName());
            writer.endElement();
        }
        if (connection.getProvides() != null) {
            writer.startElement("provider");
            this.addQNameAttribute(writer, "interface-name", connection.getProvides().getInterfaceName(), namespaceMap);
            this.addQNameAttribute(writer, "service-name", connection.getProvides().getServiceName(), namespaceMap);
            this.addStringAttribute(writer, "endpoint-name", connection.getProvides().getEndpointName());
            writer.endElement();
        }
        writer.endElement();
    }

    private void writeServiceUnit(XMLWriter writer, DependencyInformation serviceUnitInfo) throws JbiPluginException {
        writer.startElement("service-unit");
        writer.startElement("identification");
        writer.startElement("name");
        writer.writeText(serviceUnitInfo.getName());
        writer.endElement();
        writer.startElement("description");
        if (serviceUnitInfo.getDescription() != null) {
            writer.writeText(serviceUnitInfo.getDescription());
        } else {
            writer.writeText(serviceUnitInfo.getName());
        }
        writer.endElement();
        writer.endElement();
        writer.startElement("target");
        writer.startElement("artifacts-zip");
        writer.writeText(serviceUnitInfo.getFilename());
        writer.endElement();
        writer.startElement("component-name");
        writer.writeText(serviceUnitInfo.getComponent());
        writer.endElement();
        writer.endElement();
        writer.endElement();
    }

    private void close(Writer closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

