/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.maven.plugin.jbi;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.servicemix.maven.plugin.jbi.AbstractJbiMojo;
import org.apache.servicemix.maven.plugin.jbi.DependencyInformation;
import org.apache.servicemix.maven.plugin.jbi.JbiPluginException;
import org.apache.servicemix.maven.plugin.jbi.JbiSharedLibraryDescriptorWriter;
import org.codehaus.plexus.util.FileUtils;

public class GenerateSharedLibraryDescriptorMojo
extends AbstractJbiMojo {
    public static final String UTF_8 = "UTF-8";
    private Boolean generateJbiDescriptor = Boolean.TRUE;
    private String name;
    private String description;
    private String version;
    private String classLoaderDelegation;
    private String encoding = "UTF-8";
    private String generatedDescriptorLocation;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)" ======= GenerateSharedLibraryDescriptorMojo settings =======");
        this.getLog().debug((CharSequence)("workDirectory[" + this.workDirectory + "]"));
        this.getLog().debug((CharSequence)("generateJbiDescriptor[" + this.generateJbiDescriptor + "]"));
        this.getLog().debug((CharSequence)("name[" + this.name + "]"));
        this.getLog().debug((CharSequence)("description[" + this.description + "]"));
        this.getLog().debug((CharSequence)("encoding[" + this.encoding + "]"));
        this.getLog().debug((CharSequence)("generatedDescriptorLocation[" + this.generatedDescriptorLocation + "]"));
        this.getLog().debug((CharSequence)("version[" + this.version + "]"));
        if (!this.generateJbiDescriptor.booleanValue()) {
            this.getLog().debug((CharSequence)"Generation of jbi.xml is disabled");
            return;
        }
        this.getLog().info((CharSequence)"Generating jbi.xml");
        try {
            this.generateJbiDescriptor();
        }
        catch (JbiPluginException e) {
            throw new MojoExecutionException("Failed to generate jbi.xml", (Exception)e);
        }
        try {
            FileUtils.copyFileToDirectory((File)new File(this.generatedDescriptorLocation, "jbi.xml"), (File)new File(this.getWorkDirectory(), "META-INF"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy jbi.xml to final destination", (Exception)e);
        }
    }

    protected void generateJbiDescriptor() throws JbiPluginException {
        File outputDir = new File(this.generatedDescriptorLocation);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        File descriptor = new File(outputDir, "jbi.xml");
        ArrayList<DependencyInformation> embeddedLibraries = new ArrayList<DependencyInformation>();
        DependencyInformation info = new DependencyInformation();
        info.setFilename("lib/" + this.project.getArtifactId() + "-" + this.project.getVersion() + ".jar");
        info.setVersion(this.project.getVersion());
        info.setName(this.project.getArtifactId());
        info.setType("jar");
        embeddedLibraries.add(info);
        Set artifacts = this.project.getArtifacts();
        for (Artifact artifact : artifacts) {
            String type;
            ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
            if (artifact.isOptional() || !filter.include(artifact) || !"jar".equals(type = artifact.getType())) continue;
            info = new DependencyInformation();
            info.setFilename("lib/" + artifact.getFile().getName());
            embeddedLibraries.add(info);
        }
        JbiSharedLibraryDescriptorWriter writer = new JbiSharedLibraryDescriptorWriter(this.encoding);
        writer.write(descriptor, this.name, this.description, this.version, this.classLoaderDelegation, embeddedLibraries);
    }
}

