/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.maven.plugin.jbi;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.logging.Log;

public class JbiResolutionListener
implements ResolutionListener {
    private Stack parents = new Stack();
    private Map artifacts = new HashMap();
    private Node rootNode;
    private Log log;

    public void setLog(Log log) {
        this.log = log;
    }

    public Log getLog() {
        return this.log;
    }

    public void testArtifact(Artifact artifact) {
    }

    public void startProcessChildren(Artifact artifact) {
        Node node = (Node)this.artifacts.get(artifact.getDependencyConflictId());
        if (this.parents.isEmpty()) {
            this.rootNode = node;
        }
        this.parents.push(node);
    }

    public void endProcessChildren(Artifact artifact) {
        Node check = (Node)this.parents.pop();
        assert (artifact.equals(check.artifact));
    }

    public void omitForNearer(Artifact omitted, Artifact kept) {
        assert (omitted.getDependencyConflictId().equals(kept.getDependencyConflictId()));
        Node node = (Node)this.artifacts.get(omitted.getDependencyConflictId());
        assert (node != null);
        node.artifact = kept;
    }

    public void omitForCycle(Artifact artifact) {
    }

    public void includeArtifact(Artifact artifact) {
        Node node = (Node)this.artifacts.get(artifact.getDependencyConflictId());
        if (node == null) {
            node = new Node();
            this.artifacts.put(artifact.getDependencyConflictId(), node);
        }
        node.artifact = artifact;
        if (!this.parents.isEmpty()) {
            Node parent = (Node)this.parents.peek();
            parent.children.add(node);
            node.parents.add(parent);
        }
        if (this.rootNode != null) {
            // empty if block
        }
    }

    protected void print(Node node, String string) {
        for (Node n : node.getChildren()) {
            this.print(n, string + "  ");
        }
    }

    public void updateScope(Artifact artifact, String scope) {
        this.getLog().debug((CharSequence)("updateScope: " + artifact));
        Node node = (Node)this.artifacts.get(artifact.getDependencyConflictId());
        node.setScope(scope);
    }

    public void manageArtifact(Artifact artifact, Artifact replacement) {
        this.getLog().debug((CharSequence)("manageArtifact: artifact=" + artifact + ", replacement=" + replacement));
        Node node = (Node)this.artifacts.get(artifact.getDependencyConflictId());
        if (node != null) {
            if (replacement.getVersion() != null) {
                node.artifact.setVersion(replacement.getVersion());
            }
            if (replacement.getScope() != null) {
                node.artifact.setScope(replacement.getScope());
            }
        }
    }

    public void updateScopeCurrentPom(Artifact artifact, String key) {
        this.getLog().debug((CharSequence)("updateScopeCurrentPom: " + artifact));
    }

    public void selectVersionFromRange(Artifact artifact) {
        this.getLog().debug((CharSequence)("selectVersionFromRange: " + artifact));
    }

    public void restrictRange(Artifact artifact, Artifact artifact1, VersionRange versionRange) {
        this.getLog().debug((CharSequence)("restrictRange: " + artifact));
    }

    public Node getNode(Artifact artifact) {
        return (Node)this.artifacts.get(artifact.getDependencyConflictId());
    }

    public Collection getArtifacts() {
        return this.artifacts.values();
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Node {
        private Set<Node> children = new HashSet<Node>();
        private Set<Node> parents = new HashSet<Node>();
        private Artifact artifact;
        private String scope;

        Node() {
        }

        public Set<Node> getChildren() {
            return this.children;
        }

        public Artifact getArtifact() {
            return this.artifact;
        }

        public Set<Node> getParents() {
            return this.parents;
        }

        public String getScope() {
            if (this.scope != null) {
                return this.scope;
            }
            return this.artifact.getScope();
        }

        public void setScope(String scope) {
            this.scope = scope;
        }
    }
}

