/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.maven.plugin.jbi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.servicemix.jbi.management.task.DeployServiceAssemblyTask;
import org.apache.servicemix.jbi.management.task.InstallComponentTask;
import org.apache.servicemix.jbi.management.task.InstallSharedLibraryTask;
import org.apache.servicemix.jbi.management.task.JbiTask;
import org.apache.servicemix.jbi.management.task.ShutDownComponentTask;
import org.apache.servicemix.jbi.management.task.ShutDownServiceAssemblyTask;
import org.apache.servicemix.jbi.management.task.StartComponentTask;
import org.apache.servicemix.jbi.management.task.StartServiceAssemblyTask;
import org.apache.servicemix.jbi.management.task.StopComponentTask;
import org.apache.servicemix.jbi.management.task.StopServiceAssemblyTask;
import org.apache.servicemix.jbi.management.task.UndeployServiceAssemblyTask;
import org.apache.servicemix.jbi.management.task.UninstallComponentTask;
import org.apache.servicemix.jbi.management.task.UninstallSharedLibraryTask;
import org.apache.servicemix.maven.plugin.jbi.AbstractDeployableMojo;
import org.apache.servicemix.maven.plugin.jbi.IsDeployedTask;

public class JbiProjectDeployerMojo
extends AbstractDeployableMojo {
    public static final String JBI_SHARED_LIBRARY = "jbi-shared-library";
    public static final String JBI_COMPONENT = "jbi-component";
    public static final String JBI_SERVICE_ASSEMBLY = "jbi-service-assembly";
    private List deploymentTypes;
    private boolean deployDependencies;
    private boolean forceUpdate;
    private boolean deferExceptions;
    private boolean deployChildren;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.deployProject();
    }

    protected void deployProject() throws MojoExecutionException {
        if (!this.deployChildren && !this.getDeployablePackagingTypes().contains(this.project.getPackaging())) {
            throw new MojoExecutionException("Project must be of packaging type [" + this.getDeployablePackagingTypes() + "]");
        }
        try {
            JbiDeployableArtifact jbiDeployable;
            Stack<JbiDeployableArtifact> dependencies = new Stack<JbiDeployableArtifact>();
            if (this.deployChildren) {
                this.resolveArtifact(this.project.getArtifact(), dependencies);
            } else {
                dependencies.add(this.resolveDeploymentPackage(this.project, this.project.getArtifact()));
                ArrayList artifactList = new ArrayList();
                artifactList.addAll(this.project.getArtifacts());
                Collections.sort(artifactList, new ArtifactDepthComparator());
                for (Artifact artifact : artifactList) {
                    this.resolveArtifact(artifact, dependencies);
                }
            }
            this.getLog().info((CharSequence)"------------------ Deployment Analysis --------------------");
            this.getLog().info((CharSequence)(this.project.getName() + " has " + (dependencies.size() - 1) + " child dependencies"));
            Iterator iterator = dependencies.iterator();
            while (iterator.hasNext()) {
                this.getLog().info((CharSequence)(" - " + iterator.next()));
            }
            this.getLog().info((CharSequence)"-----------------------------------------------------------");
            if (this.deployDependencies) {
                if (!this.deferExceptions) {
                    for (JbiDeployableArtifact jbiDeployable2 : dependencies) {
                        if (!this.forceUpdate || !this.isDeployed(jbiDeployable2)) continue;
                        this.stopDependency(jbiDeployable2);
                        this.undeployDependency(jbiDeployable2);
                    }
                }
                while (!dependencies.empty()) {
                    jbiDeployable = (JbiDeployableArtifact)dependencies.pop();
                    if (!this.forceUpdate && this.isDeployed(jbiDeployable)) continue;
                    this.deployDependency(jbiDeployable, this.deferExceptions);
                    if (this.deferExceptions) continue;
                    this.startDependency(jbiDeployable);
                }
            } else {
                jbiDeployable = (JbiDeployableArtifact)dependencies.firstElement();
                if (this.isDeployed(jbiDeployable)) {
                    this.stopDependency(jbiDeployable);
                    this.undeployDependency(jbiDeployable);
                }
                this.deployDependency(jbiDeployable, this.deferExceptions);
                this.startDependency(jbiDeployable);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to deploy project, " + e.getMessage(), e);
        }
    }

    protected void startDependency(JbiDeployableArtifact jbiDeployable) {
        StartServiceAssemblyTask startTask;
        this.getLog().info((CharSequence)("Starting " + jbiDeployable.getName()));
        if (JBI_SERVICE_ASSEMBLY.equals(jbiDeployable.getType())) {
            startTask = new StartServiceAssemblyTask();
            this.initializeJbiTask((JbiTask)startTask);
            startTask.setName(jbiDeployable.getName());
            startTask.execute();
        }
        if (JBI_COMPONENT.equals(jbiDeployable.getType())) {
            startTask = new StartComponentTask();
            this.initializeJbiTask((JbiTask)startTask);
            startTask.setName(jbiDeployable.getName());
            startTask.execute();
        }
    }

    protected void undeployDependency(JbiDeployableArtifact jbiDeployable) {
        this.getLog().info((CharSequence)("Undeploying " + jbiDeployable.getFile()));
        if (JBI_SHARED_LIBRARY.equals(jbiDeployable.getType())) {
            UninstallSharedLibraryTask sharedLibraryTask = new UninstallSharedLibraryTask();
            this.initializeJbiTask((JbiTask)sharedLibraryTask);
            sharedLibraryTask.setName(jbiDeployable.getName());
            sharedLibraryTask.execute();
        } else if (JBI_SERVICE_ASSEMBLY.equals(jbiDeployable.getType())) {
            UndeployServiceAssemblyTask serviceAssemblyTask = new UndeployServiceAssemblyTask();
            this.initializeJbiTask((JbiTask)serviceAssemblyTask);
            serviceAssemblyTask.setName(jbiDeployable.getName());
            serviceAssemblyTask.execute();
        }
        if (JBI_COMPONENT.equals(jbiDeployable.getType())) {
            UninstallComponentTask componentTask = new UninstallComponentTask();
            this.initializeJbiTask((JbiTask)componentTask);
            componentTask.setName(jbiDeployable.getName());
            componentTask.execute();
        }
    }

    protected boolean isDeployed(JbiDeployableArtifact jbiDeployable) {
        IsDeployedTask isDeployedTask = new IsDeployedTask();
        isDeployedTask.setType(jbiDeployable.getType());
        isDeployedTask.setName(jbiDeployable.getName());
        this.initializeJbiTask(isDeployedTask);
        isDeployedTask.execute();
        boolean deployed = isDeployedTask.isDeployed();
        if (deployed) {
            this.getLog().info((CharSequence)(jbiDeployable.getName() + " is deployed"));
        } else {
            this.getLog().info((CharSequence)(jbiDeployable.getName() + " is not deployed"));
        }
        return deployed;
    }

    protected void stopDependency(JbiDeployableArtifact jbiDeployable) {
        ShutDownServiceAssemblyTask shutdownTask;
        StopServiceAssemblyTask stopTask;
        this.getLog().info((CharSequence)("Stopping " + jbiDeployable.getName()));
        if (JBI_SERVICE_ASSEMBLY.equals(jbiDeployable.getType())) {
            stopTask = new StopServiceAssemblyTask();
            this.initializeJbiTask((JbiTask)stopTask);
            stopTask.setName(jbiDeployable.getName());
            stopTask.execute();
            shutdownTask = new ShutDownServiceAssemblyTask();
            this.initializeJbiTask((JbiTask)shutdownTask);
            shutdownTask.setName(jbiDeployable.getName());
            shutdownTask.execute();
        }
        if (JBI_COMPONENT.equals(jbiDeployable.getType())) {
            stopTask = new StopComponentTask();
            this.initializeJbiTask((JbiTask)stopTask);
            stopTask.setName(jbiDeployable.getName());
            stopTask.execute();
            shutdownTask = new ShutDownComponentTask();
            this.initializeJbiTask((JbiTask)shutdownTask);
            shutdownTask.setName(jbiDeployable.getName());
            shutdownTask.execute();
        }
    }

    protected void deployDependency(JbiDeployableArtifact jbiDeployable, boolean doDeferExceptions) throws MojoExecutionException {
        InstallSharedLibraryTask componentTask;
        this.getLog().info((CharSequence)("Deploying " + jbiDeployable.getType() + " from " + jbiDeployable.getFile()));
        if (JBI_SHARED_LIBRARY.equals(jbiDeployable.getType())) {
            componentTask = new InstallSharedLibraryTask();
            this.initializeJbiTask((JbiTask)componentTask);
            componentTask.setFile(jbiDeployable.getFile());
            componentTask.setDeferExceptions(doDeferExceptions);
            componentTask.execute();
        } else if (JBI_SERVICE_ASSEMBLY.equals(jbiDeployable.getType())) {
            componentTask = new DeployServiceAssemblyTask();
            this.initializeJbiTask((JbiTask)componentTask);
            componentTask.setFile(jbiDeployable.getFile());
            componentTask.setDeferExceptions(doDeferExceptions);
            componentTask.execute();
        }
        if (JBI_COMPONENT.equals(jbiDeployable.getType())) {
            componentTask = new InstallComponentTask();
            this.initializeJbiTask((JbiTask)componentTask);
            componentTask.setFile(jbiDeployable.getFile());
            componentTask.setDeferExceptions(doDeferExceptions);
            componentTask.execute();
        }
    }

    protected List getDeployablePackagingTypes() {
        if (this.deploymentTypes == null) {
            this.deploymentTypes = new ArrayList();
            this.deploymentTypes.add(JBI_SHARED_LIBRARY);
            this.deploymentTypes.add(JBI_SERVICE_ASSEMBLY);
            this.deploymentTypes.add(JBI_COMPONENT);
        }
        return this.deploymentTypes;
    }

    private Collection resolveArtifact(Artifact artifact, Stack dependencies) throws ArtifactResolutionException, ArtifactNotFoundException {
        MavenProject project = null;
        try {
            project = this.projectBuilder.buildFromRepository(artifact, this.remoteRepos, this.localRepo, false);
        }
        catch (ProjectBuildingException e) {
            this.getLog().warn((CharSequence)("Unable to determine packaging for dependency : " + artifact.getArtifactId() + " assuming jar"));
        }
        if (project != null) {
            if (this.getDeployablePackagingTypes().contains(project.getPackaging())) {
                this.getLog().debug((CharSequence)("Checking for dependency from project " + project.getArtifactId()));
                JbiDeployableArtifact deployableArtifact = this.resolveDeploymentPackage(project, artifact);
                if (!dependencies.contains(deployableArtifact)) {
                    this.getLog().debug((CharSequence)("Adding dependency from project " + project.getArtifactId()));
                    dependencies.push(deployableArtifact);
                }
                ArrayList artifactList = new ArrayList();
                artifactList.addAll(project.getArtifacts());
                Collections.sort(artifactList, new ArtifactDepthComparator());
                Iterator iter = artifactList.iterator();
                while (iter.hasNext()) {
                    this.resolveArtifact((Artifact)iter.next(), dependencies);
                }
            } else {
                this.getLog().debug((CharSequence)("Ignoring non-jbi dependency: " + project.getArtifactId() + " of type " + project.getPackaging()));
            }
        }
        return dependencies;
    }

    protected JbiDeployableArtifact resolveDeploymentPackage(MavenProject project, Artifact artifact) throws ArtifactResolutionException, ArtifactNotFoundException {
        Artifact jbiArtifact = this.factory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "zip", this.getExtension(project));
        this.resolver.resolve(jbiArtifact, this.remoteRepos, this.localRepo);
        return new JbiDeployableArtifact(project.getArtifactId(), project.getPackaging(), jbiArtifact.getFile().getAbsolutePath());
    }

    protected String getExtension(MavenProject project2) {
        if (project2.getPackaging().equals(JBI_SERVICE_ASSEMBLY)) {
            return "";
        }
        return "installer";
    }

    protected class JbiDeployableArtifact {
        private String file;
        private String type;
        private String name;

        public JbiDeployableArtifact(String name, String type, String file) {
            this.name = name;
            this.file = file;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getFile() {
            return this.file;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return this.type + " : " + this.file;
        }

        public boolean equals(Object obj) {
            if (obj instanceof JbiDeployableArtifact) {
                return ((JbiDeployableArtifact)obj).toString().equals(this.toString());
            }
            return false;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }

    protected class ArtifactDepthComparator
    implements Comparator {
        protected ArtifactDepthComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            int size2;
            int size1 = ((Artifact)arg0).getDependencyTrail().size();
            if (size1 == (size2 = ((Artifact)arg1).getDependencyTrail().size())) {
                return 0;
            }
            if (size1 > size2) {
                return 1;
            }
            return -1;
        }
    }
}

