/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.maven.plugin.jbi;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.servicemix.common.packaging.Consumes;
import org.apache.servicemix.common.packaging.Provides;
import org.apache.servicemix.common.packaging.ServiceUnitAnalyzer;
import org.apache.servicemix.maven.plugin.jbi.XmlDescriptorHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JbiServiceFileAnalyzer
implements ServiceUnitAnalyzer {
    public static final String JBI_NAMESPACE = "http://java.sun.com/xml/ns/jbi";
    private final List consumes = new ArrayList();
    private final List provides = new ArrayList();

    public List getConsumes() {
        return this.consumes;
    }

    public List getProvides() {
        return this.provides;
    }

    public void init(File explodedServiceUnitRoot) {
    }

    public void setJbiServicesFile(File jbiServicesFile) throws MojoExecutionException {
        this.parseXml(jbiServicesFile);
    }

    private void parseXml(File jbiServicesFile) throws MojoExecutionException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(jbiServicesFile);
            NodeList childNodes = doc.getChildNodes();
            Node servicesNode = null;
            for (int i = 0; i < childNodes.getLength(); ++i) {
                if (!XmlDescriptorHelper.isElement(childNodes.item(i), JBI_NAMESPACE, "services")) continue;
                servicesNode = childNodes.item(i);
                break;
            }
            if (servicesNode != null) {
                Element servicesElement = (Element)servicesNode;
                NodeList children = servicesElement.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    if (!(children.item(i) instanceof Element)) continue;
                    Element childElement = (Element)children.item(i);
                    if (XmlDescriptorHelper.isElement(childElement, JBI_NAMESPACE, "consumes")) {
                        Consumes newConsumes = new Consumes();
                        newConsumes.setEndpointName(XmlDescriptorHelper.getEndpointName(childElement));
                        newConsumes.setInterfaceName(XmlDescriptorHelper.getInterfaceName(childElement));
                        newConsumes.setServiceName(XmlDescriptorHelper.getServiceName(childElement));
                        this.consumes.add(newConsumes);
                        continue;
                    }
                    if (!XmlDescriptorHelper.isElement(childElement, JBI_NAMESPACE, "provides")) continue;
                    Provides newProvides = new Provides();
                    newProvides.setEndpointName(XmlDescriptorHelper.getEndpointName(childElement));
                    newProvides.setInterfaceName(XmlDescriptorHelper.getInterfaceName(childElement));
                    newProvides.setServiceName(XmlDescriptorHelper.getServiceName(childElement));
                    this.provides.add(newProvides);
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to parse " + jbiServicesFile.getAbsolutePath());
        }
    }
}

