/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.maven.plugin.jbi;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.servicemix.maven.plugin.jbi.JbiResolutionListener;

public abstract class AbstractJbiMojo
extends AbstractMojo {
    public static final String META_INF = "META-INF";
    public static final String JBI_DESCRIPTOR = "jbi.xml";
    public static final String LIB_DIRECTORY = "lib";
    protected MavenProjectHelper projectHelper;
    protected MavenProject project;
    protected File workDirectory;
    protected MavenProjectBuilder projectBuilder;
    protected ArtifactRepository localRepo;
    protected List remoteRepos;
    protected ArtifactMetadataSource artifactMetadataSource;
    protected ArtifactResolver resolver;
    protected ArtifactCollector collector;
    protected ArtifactFactory factory;

    protected MavenProject getProject() {
        return this.project;
    }

    protected File getWorkDirectory() {
        return this.workDirectory;
    }

    public MavenProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    protected void removeBranch(JbiResolutionListener listener, Artifact artifact) {
        JbiResolutionListener.Node n = listener.getNode(artifact);
        if (n != null && n.getParent() != null) {
            n.getParent().getChildren().remove(n);
        }
    }

    protected void removeChildren(JbiResolutionListener listener, Artifact artifact) {
        JbiResolutionListener.Node n = listener.getNode(artifact);
        n.getChildren().clear();
    }

    protected Set getArtifacts(JbiResolutionListener.Node n, Set s) {
        s.add(n.getArtifact());
        Iterator iter = n.getChildren().iterator();
        while (iter.hasNext()) {
            JbiResolutionListener.Node c = (JbiResolutionListener.Node)iter.next();
            this.getArtifacts(c, s);
        }
        return s;
    }

    protected void excludeBranch(JbiResolutionListener.Node n, Set excludes) {
        excludes.add(n);
        Iterator iter = n.getChildren().iterator();
        while (iter.hasNext()) {
            JbiResolutionListener.Node c = (JbiResolutionListener.Node)iter.next();
            this.excludeBranch(c, excludes);
        }
    }

    protected void print(JbiResolutionListener.Node rootNode, String string) {
        this.getLog().info((CharSequence)(string + rootNode.getArtifact()));
        Iterator iter = rootNode.getChildren().iterator();
        while (iter.hasNext()) {
            JbiResolutionListener.Node n = (JbiResolutionListener.Node)iter.next();
            this.print(n, string + "  ");
        }
    }

    protected Set retainArtifacts(Set includes, JbiResolutionListener listener) {
        HashSet<Artifact> finalIncludes = new HashSet<Artifact>();
        Set filteredArtifacts = this.getArtifacts(listener.getRootNode(), new HashSet());
        Iterator iter = includes.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            Iterator iter2 = filteredArtifacts.iterator();
            while (iter2.hasNext()) {
                Artifact filteredArtifact = (Artifact)iter2.next();
                if (!filteredArtifact.getArtifactId().equals(artifact.getArtifactId()) || !filteredArtifact.getType().equals(artifact.getType()) || !filteredArtifact.getGroupId().equals(artifact.getGroupId())) continue;
                if (!filteredArtifact.getVersion().equals(artifact.getVersion())) {
                    this.getLog().warn((CharSequence)("Resolved artifact " + artifact + " has a different version from that in dependency management " + filteredArtifact + ", overriding dependency management"));
                }
                finalIncludes.add(artifact);
            }
        }
        return finalIncludes;
    }

    protected JbiResolutionListener resolveProject() {
        Map managedVersions = null;
        try {
            managedVersions = this.createManagedVersionMap(this.project.getId(), this.project.getDependencyManagement());
        }
        catch (ProjectBuildingException e) {
            this.getLog().error((CharSequence)"An error occurred while resolving project dependencies.", (Throwable)e);
        }
        JbiResolutionListener listener = new JbiResolutionListener();
        try {
            this.collector.collect(this.project.getDependencyArtifacts(), this.project.getArtifact(), managedVersions, this.localRepo, this.remoteRepos, this.artifactMetadataSource, null, Collections.singletonList(listener));
        }
        catch (ArtifactResolutionException e) {
            this.getLog().error((CharSequence)"An error occurred while resolving project dependencies.", (Throwable)e);
        }
        return listener;
    }

    protected Map createManagedVersionMap(String projectId, DependencyManagement dependencyManagement) throws ProjectBuildingException {
        HashMap<String, Artifact> map;
        if (dependencyManagement != null && dependencyManagement.getDependencies() != null) {
            map = new HashMap<String, Artifact>();
            Iterator i = dependencyManagement.getDependencies().iterator();
            while (i.hasNext()) {
                Dependency d = (Dependency)i.next();
                try {
                    VersionRange versionRange = VersionRange.createFromVersionSpec((String)d.getVersion());
                    Artifact artifact = this.factory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), d.getScope());
                    map.put(d.getManagementKey(), artifact);
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new ProjectBuildingException(projectId, "Unable to parse version '" + d.getVersion() + "' for dependency '" + d.getManagementKey() + "': " + e.getMessage(), (Throwable)e);
                }
            }
        } else {
            map = Collections.EMPTY_MAP;
        }
        return map;
    }

    protected URLClassLoader getClassLoader() throws MojoExecutionException {
        try {
            HashSet<URL> urls = new HashSet<URL>();
            URL mainClasses = new File(this.project.getBuild().getOutputDirectory()).toURL();
            this.getLog().debug((CharSequence)("Adding to classpath : " + mainClasses));
            urls.add(mainClasses);
            URL testClasses = new File(this.project.getBuild().getTestOutputDirectory()).toURL();
            this.getLog().debug((CharSequence)("Adding to classpath : " + testClasses));
            urls.add(testClasses);
            Set dependencies = this.project.getArtifacts();
            Iterator iter = dependencies.iterator();
            while (iter.hasNext()) {
                Artifact classPathElement = (Artifact)iter.next();
                this.getLog().debug((CharSequence)("Adding artifact: " + classPathElement.getFile() + " to classpath"));
                urls.add(classPathElement.getFile().toURL());
            }
            URLClassLoader appClassloader = new URLClassLoader(urls.toArray(new URL[urls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
            return appClassloader;
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error during setting up classpath", (Exception)e);
        }
    }
}

