/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.maven.plugin.jbi;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.servicemix.common.packaging.Consumes;
import org.apache.servicemix.common.packaging.Provides;
import org.apache.servicemix.maven.plugin.jbi.AbstractJbiMojo;
import org.apache.servicemix.maven.plugin.jbi.DependencyInformation;
import org.apache.servicemix.maven.plugin.jbi.JbiPluginException;
import org.apache.servicemix.maven.plugin.jbi.JbiResolutionListener;
import org.apache.servicemix.maven.plugin.jbi.JbiServiceAssemblyDescriptorWriter;
import org.apache.servicemix.maven.plugin.jbi.XmlDescriptorHelper;
import org.codehaus.plexus.util.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GenerateServiceAssemblyDescriptorMojo
extends AbstractJbiMojo {
    private static final String JBI_NAMESPACE = "http://java.sun.com/xml/ns/jbi";
    public static final String UTF_8 = "UTF-8";
    private Boolean generateJbiDescriptor = Boolean.TRUE;
    private String name;
    private String description;
    private String encoding = "UTF-8";
    private String generatedDescriptorLocation;
    private File jbiConnectionsFile;
    private JbiResolutionListener listener;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)" ======= GenerateServiceAssemlbyDescriptorMojo settings =======");
        this.getLog().debug((CharSequence)("workDirectory[" + this.workDirectory + "]"));
        this.getLog().debug((CharSequence)("generateJbiDescriptor[" + this.generateJbiDescriptor + "]"));
        this.getLog().debug((CharSequence)("name[" + this.name + "]"));
        this.getLog().debug((CharSequence)("description[" + this.description + "]"));
        this.getLog().debug((CharSequence)("encoding[" + this.encoding + "]"));
        this.getLog().debug((CharSequence)("generatedDescriptorLocation[" + this.generatedDescriptorLocation + "]"));
        if (!this.generateJbiDescriptor.booleanValue()) {
            this.getLog().debug((CharSequence)"Generation of jbi.xml is disabled");
            return;
        }
        this.getLog().info((CharSequence)"Generating jbi.xml");
        try {
            this.listener = this.resolveProject();
            this.generateJbiDescriptor();
        }
        catch (JbiPluginException e) {
            throw new MojoExecutionException("Failed to generate jbi.xml", (Exception)e);
        }
        try {
            FileUtils.copyFileToDirectory((File)new File(this.generatedDescriptorLocation, "jbi.xml"), (File)new File(this.getWorkDirectory(), "META-INF"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy jbi.xml to final destination", (Exception)e);
        }
    }

    protected void generateJbiDescriptor() throws JbiPluginException, MojoExecutionException {
        File outputDir = new File(this.generatedDescriptorLocation);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        File descriptor = new File(outputDir, "jbi.xml");
        ArrayList<DependencyInformation> serviceUnits = new ArrayList<DependencyInformation>();
        Set artifacts = this.project.getArtifacts();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
            if (artifact.isOptional() || !filter.include(artifact) || artifact.getDependencyTrail().size() != 2) continue;
            MavenProject project = null;
            try {
                project = this.projectBuilder.buildFromRepository(artifact, this.remoteRepos, this.localRepo);
            }
            catch (ProjectBuildingException e) {
                this.getLog().warn((CharSequence)("Unable to determine packaging for dependency : " + artifact.getArtifactId() + " assuming jar"));
            }
            if (project == null || !project.getPackaging().equals("jbi-service-unit")) continue;
            DependencyInformation info = new DependencyInformation();
            info.setName(artifact.getArtifactId());
            String name = artifact.getFile().getName();
            name = name.substring(0, name.lastIndexOf(46)) + ".zip";
            info.setFilename(name);
            info.setComponent(this.getComponentName(project, artifacts, artifact));
            info.setDescription(project.getDescription());
            serviceUnits.add(info);
        }
        List orderedServiceUnits = this.reorderServiceUnits(serviceUnits);
        List connections = this.getConnections();
        JbiServiceAssemblyDescriptorWriter writer = new JbiServiceAssemblyDescriptorWriter(this.encoding);
        writer.write(descriptor, this.name, this.description, orderedServiceUnits, connections);
    }

    private List getConnections() throws MojoExecutionException {
        if (this.jbiConnectionsFile.exists()) {
            return this.parseConnectionsXml();
        }
        return new ArrayList();
    }

    private List parseConnectionsXml() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Picking up connections from " + this.jbiConnectionsFile.getAbsolutePath()));
        ArrayList<Connection> connections = new ArrayList<Connection>();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(this.jbiConnectionsFile);
            Node servicesNode = doc.getFirstChild();
            if (servicesNode instanceof Element && XmlDescriptorHelper.isElement(servicesNode, JBI_NAMESPACE, "connections")) {
                Element servicesElement = (Element)servicesNode;
                NodeList children = servicesElement.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    if (!XmlDescriptorHelper.isElement(children.item(i), JBI_NAMESPACE, "connection")) continue;
                    Connection connection = new Connection();
                    NodeList connectionChildren = children.item(i).getChildNodes();
                    for (int x = 0; x < connectionChildren.getLength(); ++x) {
                        if (!(connectionChildren.item(x) instanceof Element)) continue;
                        Element childElement = (Element)connectionChildren.item(x);
                        if (XmlDescriptorHelper.isElement(childElement, JBI_NAMESPACE, "consumer")) {
                            Consumes newConsumes = new Consumes();
                            newConsumes.setEndpointName(XmlDescriptorHelper.getEndpointName(childElement));
                            newConsumes.setInterfaceName(XmlDescriptorHelper.getInterfaceName(childElement));
                            newConsumes.setServiceName(XmlDescriptorHelper.getServiceName(childElement));
                            connection.setConsumes(newConsumes);
                            continue;
                        }
                        if (!XmlDescriptorHelper.isElement(childElement, JBI_NAMESPACE, "provider")) continue;
                        Provides newProvides = new Provides();
                        newProvides.setEndpointName(XmlDescriptorHelper.getEndpointName(childElement));
                        newProvides.setInterfaceName(XmlDescriptorHelper.getInterfaceName(childElement));
                        newProvides.setServiceName(XmlDescriptorHelper.getServiceName(childElement));
                        connection.setProvides(newProvides);
                    }
                    connections.add(connection);
                }
            }
            this.getLog().info((CharSequence)("Found " + connections.size() + " connections"));
            return connections;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to parse " + this.jbiConnectionsFile.getAbsolutePath());
        }
    }

    private List reorderServiceUnits(List serviceUnits) throws MojoExecutionException {
        Iterator dependencies = this.getReparsedDependencies();
        ArrayList<DependencyInformation> orderedServiceUnits = new ArrayList<DependencyInformation>();
        while (dependencies.hasNext()) {
            Dependency dependency = (Dependency)dependencies.next();
            Iterator it = serviceUnits.iterator();
            while (it.hasNext()) {
                DependencyInformation serviceUnitInfo = (DependencyInformation)it.next();
                if (!dependency.getArtifactId().equals(serviceUnitInfo.getName())) continue;
                System.out.println("Adding " + serviceUnitInfo.getFilename());
                orderedServiceUnits.add(serviceUnitInfo);
            }
        }
        return orderedServiceUnits;
    }

    private Iterator getReparsedDependencies() throws MojoExecutionException {
        MavenXpp3Reader mavenXpp3Reader = new MavenXpp3Reader();
        try {
            Model model = mavenXpp3Reader.read((Reader)new FileReader(new File(this.project.getBasedir(), "pom.xml")), false);
            return model.getDependencies().iterator();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to reparse the pom.xml");
        }
    }

    private String getComponentName(MavenProject project, Set artifacts, Artifact suArtifact) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Determining component name for service unit " + project.getArtifactId()));
        if (project.getProperties().getProperty("componentName") != null) {
            return project.getProperties().getProperty("componentName");
        }
        JbiResolutionListener.Node n = this.listener.getNode(suArtifact);
        Iterator it = n.getChildren().iterator();
        while (it.hasNext()) {
            JbiResolutionListener.Node child = (JbiResolutionListener.Node)it.next();
            MavenProject artifactProject = null;
            try {
                artifactProject = this.projectBuilder.buildFromRepository(child.getArtifact(), this.remoteRepos, this.localRepo);
            }
            catch (ProjectBuildingException e) {
                this.getLog().warn((CharSequence)("Unable to determine packaging for dependency : " + child.getArtifact().getArtifactId() + " assuming jar"));
            }
            this.getLog().info((CharSequence)("Project " + artifactProject + " packaged " + artifactProject.getPackaging()));
            if (artifactProject == null || !artifactProject.getPackaging().equals("jbi-component")) continue;
            return child.getArtifact().getArtifactId();
        }
        throw new MojoExecutionException("The service unit " + project.getArtifactId() + " does not have a dependency which is packaged as a jbi-component or a project property 'componentName'");
    }

    public class Connection {
        private Consumes consumes;
        private Provides provides;

        public Consumes getConsumes() {
            return this.consumes;
        }

        public void setConsumes(Consumes consumes) {
            this.consumes = consumes;
        }

        public Provides getProvides() {
            return this.provides;
        }

        public void setProvides(Provides provides) {
            this.provides = provides;
        }
    }
}

