/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.maven.plugin.jbi;

import org.apache.servicemix.jbi.framework.AdminCommandsServiceMBean;
import org.apache.servicemix.jbi.management.task.JbiTask;

public class IsDeployedTask
extends JbiTask {
    private static final String JBI_SHARED_LIBRARY = "jbi-shared-library";
    private static final String JBI_COMPONENT = "jbi-component";
    private static final String JBI_SERVICE_ASSEMBLY = "jbi-service-assembly";
    private boolean deployed = false;
    private String type;
    private String name;

    public boolean isDeployed() {
        return this.deployed;
    }

    public void setDeployed(boolean deployed) {
        this.deployed = deployed;
    }

    protected void doExecute(AdminCommandsServiceMBean acs) throws Exception {
        String result;
        if (JBI_SHARED_LIBRARY.equals(this.type)) {
            result = acs.listSharedLibraries(null, this.name);
            this.setDeployed(this.isResultContaining(result, "shared-library", this.name));
        } else if (JBI_SERVICE_ASSEMBLY.equals(this.type)) {
            result = acs.listServiceAssemblies(null, null, this.name);
            this.setDeployed(result.contains("<service-assembly-info name='" + this.name + "'"));
        }
        if (JBI_COMPONENT.equals(this.type) && (this.isResultContaining(result = acs.listComponents(false, false, false, null, null, null), "service-engine", this.name) || this.isResultContaining(result, "binding-component", this.name))) {
            this.setDeployed(true);
        }
    }

    private boolean isResultContaining(String result, String type, String name) {
        String componentLine = "<component-info type='" + type + "' name='" + name + "'";
        return result.contains(componentLine);
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }
}

