/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.maven.plugin.jbi;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.servicemix.maven.plugin.jbi.DependencyInformation;
import org.apache.servicemix.maven.plugin.jbi.JbiPluginException;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;

public class JbiSharedLibraryDescriptorWriter {
    private final String encoding;

    public JbiSharedLibraryDescriptorWriter(String encoding) {
        this.encoding = encoding;
    }

    public void write(File descriptor, String name, String description, String version, String classLoaderDelegation, List uris) throws JbiPluginException {
        FileWriter w;
        try {
            w = new FileWriter(descriptor);
        }
        catch (IOException ex) {
            throw new JbiPluginException("Exception while opening file[" + descriptor.getAbsolutePath() + "]", ex);
        }
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w, this.encoding, null);
        writer.startElement("jbi");
        writer.addAttribute("xmlns", "http://java.sun.com/xml/ns/jbi");
        writer.addAttribute("version", "1.0");
        writer.startElement("shared-library");
        writer.addAttribute("class-loader-delegation", classLoaderDelegation);
        writer.addAttribute("version", version);
        writer.startElement("identification");
        writer.startElement("name");
        writer.writeText(name);
        writer.endElement();
        writer.startElement("description");
        writer.writeText(description);
        writer.endElement();
        writer.endElement();
        writer.startElement("shared-library-class-path");
        Iterator it = uris.iterator();
        while (it.hasNext()) {
            DependencyInformation dependency = (DependencyInformation)it.next();
            writer.startElement("path-element");
            writer.writeText(dependency.getFilename());
            writer.endElement();
        }
        writer.endElement();
        writer.endElement();
        writer.endElement();
        this.close(w);
    }

    private void close(Writer closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

