/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.maven.plugin.jbi;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.servicemix.maven.plugin.jbi.AbstractJbiMojo;
import org.apache.servicemix.maven.plugin.jbi.DependencyInformation;
import org.apache.servicemix.maven.plugin.jbi.JbiComponentDescriptorWriter;
import org.apache.servicemix.maven.plugin.jbi.JbiPluginException;
import org.apache.servicemix.maven.plugin.jbi.JbiResolutionListener;
import org.codehaus.plexus.util.FileUtils;

public class GenerateComponentDescriptorMojo
extends AbstractJbiMojo {
    public static final String UTF_8 = "UTF-8";
    private Boolean generateJbiDescriptor = Boolean.TRUE;
    private String component;
    private String bootstrap;
    private String type;
    private String name;
    private File defaultBootstrapFile;
    private String description;
    private String encoding = "UTF-8";
    private String generatedDescriptorLocation;
    private String componentClassLoaderDelegation;
    private String bootstrapClassLoaderDelegation;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)" ======= GenerateComponentDescriptorMojo settings =======");
        this.getLog().debug((CharSequence)("workDirectory[" + this.workDirectory + "]"));
        this.getLog().debug((CharSequence)("generateJbiDescriptor[" + this.generateJbiDescriptor + "]"));
        this.getLog().debug((CharSequence)("type[" + this.type + "]"));
        this.getLog().debug((CharSequence)("component[" + this.component + "]"));
        this.getLog().debug((CharSequence)("bootstrap[" + this.bootstrap + "]"));
        this.getLog().debug((CharSequence)("name[" + this.name + "]"));
        this.getLog().debug((CharSequence)("description[" + this.description + "]"));
        this.getLog().debug((CharSequence)("encoding[" + this.encoding + "]"));
        this.getLog().debug((CharSequence)("generatedDescriptorLocation[" + this.generatedDescriptorLocation + "]"));
        if (!this.generateJbiDescriptor.booleanValue()) {
            this.getLog().debug((CharSequence)"Generation of jbi.xml is disabled");
            return;
        }
        if (this.bootstrap == null) {
            this.injectBootStrap();
        }
        this.getLog().info((CharSequence)"Generating jbi.xml");
        try {
            this.generateJbiDescriptor();
        }
        catch (JbiPluginException e) {
            throw new MojoExecutionException("Failed to generate jbi.xml", (Exception)e);
        }
        try {
            FileUtils.copyFileToDirectory((File)new File(this.generatedDescriptorLocation, "jbi.xml"), (File)new File(this.getWorkDirectory(), "META-INF"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy jbi.xml to final destination", (Exception)e);
        }
    }

    private void injectBootStrap() throws MojoExecutionException {
        try {
            URL defaultBootStrap = this.getClassLoader().getResource("org/apache/servicemix/common/DefaultBootstrap.class");
            FileUtils.copyURLToFile((URL)defaultBootStrap, (File)this.defaultBootstrapFile);
            this.bootstrap = "org.apache.servicemix.common.DefaultBootstrap";
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy DefaultBootstrap.class to " + this.defaultBootstrapFile.getAbsolutePath(), (Exception)e);
        }
    }

    protected void generateJbiDescriptor() throws JbiPluginException {
        String type;
        MavenProject project;
        Artifact artifact;
        File outputDir = new File(this.generatedDescriptorLocation);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        File descriptor = new File(outputDir, "jbi.xml");
        ArrayList<DependencyInformation> uris = new ArrayList<DependencyInformation>();
        DependencyInformation info = new DependencyInformation();
        info.setFilename("lib/" + this.project.getArtifactId() + "-" + this.project.getVersion() + ".jar");
        info.setVersion(this.project.getVersion());
        info.setName(this.project.getArtifactId());
        info.setType("jar");
        uris.add(info);
        ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
        JbiResolutionListener listener = this.resolveProject();
        HashSet<Artifact> includes = new HashSet<Artifact>();
        Iterator iter = this.project.getArtifacts().iterator();
        while (iter.hasNext()) {
            artifact = (Artifact)iter.next();
            if (artifact.isOptional() || !filter.include(artifact)) continue;
            project = null;
            try {
                project = this.projectBuilder.buildFromRepository(artifact, this.remoteRepos, this.localRepo);
            }
            catch (ProjectBuildingException e) {
                this.getLog().warn((CharSequence)("Unable to determine packaging for dependency : " + artifact.getArtifactId() + " assuming jar"));
            }
            String string = type = project != null ? project.getPackaging() : artifact.getType();
            if ("jbi-shared-library".equals(type)) {
                this.removeChildren(listener, artifact);
                includes.add(artifact);
                continue;
            }
            if (!"jar".equals(type)) continue;
            includes.add(artifact);
        }
        iter = this.retainArtifacts(includes, listener).iterator();
        while (iter.hasNext()) {
            artifact = (Artifact)iter.next();
            project = null;
            try {
                project = this.projectBuilder.buildFromRepository(artifact, this.remoteRepos, this.localRepo);
            }
            catch (ProjectBuildingException e) {
                this.getLog().warn((CharSequence)("Unable to determine packaging for dependency : " + artifact.getArtifactId() + " assuming jar"));
            }
            type = project != null ? project.getPackaging() : artifact.getType();
            info = new DependencyInformation();
            info.setFilename("lib/" + artifact.getFile().getName());
            info.setVersion(artifact.getVersion());
            info.setName(artifact.getArtifactId());
            info.setType(type);
            uris.add(info);
        }
        JbiComponentDescriptorWriter writer = new JbiComponentDescriptorWriter(this.encoding);
        writer.write(descriptor, this.component, this.bootstrap, this.type, this.name, this.description, this.componentClassLoaderDelegation, this.bootstrapClassLoaderDelegation, uris);
    }
}

