/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.maven.plugin.jbi;

import java.io.File;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.servicemix.common.packaging.ServiceUnitAnalyzer;
import org.apache.servicemix.maven.plugin.jbi.AbstractJbiMojo;
import org.apache.servicemix.maven.plugin.jbi.JbiPluginException;
import org.apache.servicemix.maven.plugin.jbi.JbiServiceFileAnalyzer;
import org.apache.servicemix.maven.plugin.jbi.JbiServiceUnitDescriptorWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class GenerateServiceUnitDescriptorMojo
extends AbstractJbiMojo {
    public static final String UTF_8 = "UTF-8";
    private Boolean generateJbiDescriptor = Boolean.TRUE;
    private Boolean useServiceUnitAnalyzer = Boolean.TRUE;
    private File jbiServicesFile;
    private String name;
    private String description;
    private String encoding = "UTF-8";
    private String generatedDescriptorLocation;
    private File serviceUnitArtifactsDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)" ======= GenerateServiceUnitDescriptorMojo settings =======");
        this.getLog().debug((CharSequence)("workDirectory[" + this.workDirectory + "]"));
        this.getLog().debug((CharSequence)("generateDescriptor[" + this.generateJbiDescriptor + "]"));
        this.getLog().debug((CharSequence)("name[" + this.name + "]"));
        this.getLog().debug((CharSequence)("description[" + this.description + "]"));
        this.getLog().debug((CharSequence)("encoding[" + this.encoding + "]"));
        this.getLog().debug((CharSequence)("generatedDescriptorLocation[" + this.generatedDescriptorLocation + "]"));
        if (!this.generateJbiDescriptor.booleanValue()) {
            this.getLog().debug((CharSequence)"Generation of jbi.xml is disabled");
            return;
        }
        this.getLog().info((CharSequence)"Generating jbi.xml");
        try {
            this.generateJbiDescriptor();
        }
        catch (JbiPluginException e) {
            throw new MojoExecutionException("Failed to generate jbi.xml", (Exception)e);
        }
    }

    protected void generateJbiDescriptor() throws JbiPluginException {
        File outputDir = new File(this.generatedDescriptorLocation);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            URLClassLoader newClassLoader = this.getClassLoader();
            Thread.currentThread().setContextClassLoader(newClassLoader);
            File descriptor = new File(outputDir, "jbi.xml");
            ArrayList uris = new ArrayList();
            JbiServiceUnitDescriptorWriter writer = new JbiServiceUnitDescriptorWriter(this.encoding);
            ArrayList consumes = new ArrayList();
            ArrayList provides = new ArrayList();
            String serviceUnitAnalyzerClazzName = this.getServiceUnitAnalyzer();
            if (serviceUnitAnalyzerClazzName != null) {
                ServiceUnitAnalyzer serviceUnitAnalyzer = (ServiceUnitAnalyzer)newClassLoader.loadClass(serviceUnitAnalyzerClazzName).newInstance();
                this.getLog().info((CharSequence)("Created Service Unit Analyzer " + serviceUnitAnalyzer));
                serviceUnitAnalyzer.init(this.serviceUnitArtifactsDir);
                if (serviceUnitAnalyzer instanceof JbiServiceFileAnalyzer) {
                    ((JbiServiceFileAnalyzer)serviceUnitAnalyzer).setJbiServicesFile(this.jbiServicesFile);
                }
                consumes.addAll(serviceUnitAnalyzer.getConsumes());
                provides.addAll(serviceUnitAnalyzer.getProvides());
            }
            this.getLog().info((CharSequence)("generated : consumes " + consumes + " provides " + provides));
            writer.write(descriptor, this.name, this.description, uris, consumes, provides);
        }
        catch (Exception e) {
            throw new JbiPluginException("Unable to generate service unit descriptor!", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private String getServiceUnitAnalyzer() {
        MavenProject project;
        if (this.jbiServicesFile.exists()) {
            return JbiServiceFileAnalyzer.class.getCanonicalName();
        }
        if (this.useServiceUnitAnalyzer.booleanValue() && (project = this.getComponentProject()) != null) {
            List plugins = project.getBuild().getPlugins();
            Iterator iterator = plugins.iterator();
            while (iterator.hasNext()) {
                Xpp3Dom o;
                Plugin plugin = (Plugin)iterator.next();
                if (!"org.apache.servicemix.tooling".equals(plugin.getGroupId()) || !"jbi-maven-plugin".equals(plugin.getArtifactId()) || (o = (Xpp3Dom)plugin.getConfiguration()) == null || o.getChild("serviceUnitAnalyzer") == null) continue;
                String clazzName = o.getChild("serviceUnitAnalyzer").getValue();
                return clazzName;
            }
        }
        return null;
    }

    private MavenProject getComponentProject() {
        Set artifacts = this.project.getArtifacts();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
            if (artifact.isOptional() || !filter.include(artifact) || artifact.getDependencyTrail().size() != 2) continue;
            MavenProject project = null;
            try {
                project = this.projectBuilder.buildFromRepository(artifact, this.remoteRepos, this.localRepo);
            }
            catch (ProjectBuildingException e) {
                this.getLog().warn((CharSequence)("Unable to determine packaging for dependency : " + artifact.getArtifactId() + " assuming jar"));
            }
            if (project == null || !project.getPackaging().equals("jbi-component")) continue;
            return project;
        }
        return null;
    }
}

