/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.maven.plugin.jbi;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.servicemix.common.packaging.Consumes;
import org.apache.servicemix.common.packaging.Provides;
import org.apache.servicemix.maven.plugin.jbi.AbstractDescriptorWriter;
import org.apache.servicemix.maven.plugin.jbi.JbiPluginException;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class JbiServiceUnitDescriptorWriter
extends AbstractDescriptorWriter {
    private final String encoding;

    public JbiServiceUnitDescriptorWriter(String encoding) {
        this.encoding = encoding;
    }

    public void write(File descriptor, String name, String description, List uris, List consumes, List provides) throws JbiPluginException {
        FileWriter w;
        try {
            w = new FileWriter(descriptor);
        }
        catch (IOException ex) {
            throw new JbiPluginException("Exception while opening file[" + descriptor.getAbsolutePath() + "]", ex);
        }
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w, this.encoding, null);
        writer.startElement("jbi");
        writer.addAttribute("xmlns", "http://java.sun.com/xml/ns/jbi");
        writer.addAttribute("version", "1.0");
        writer.startElement("services");
        Map namespaceMap = this.getNamespaceMap(provides, consumes);
        Iterator<Object> iterator = namespaceMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            StringBuffer namespaceDecl = new StringBuffer();
            namespaceDecl.append("xmlns:");
            namespaceDecl.append(namespaceMap.get(key));
            writer.addAttribute(namespaceDecl.toString(), key);
        }
        iterator = provides.iterator();
        while (iterator.hasNext()) {
            Provides providesEntry = (Provides)iterator.next();
            writer.startElement("provides");
            this.addQNameAttribute((XMLWriter)writer, "interface-name", providesEntry.getInterfaceName(), namespaceMap);
            this.addQNameAttribute((XMLWriter)writer, "service-name", providesEntry.getServiceName(), namespaceMap);
            this.addStringAttribute((XMLWriter)writer, "endpoint-name", providesEntry.getEndpointName());
            writer.endElement();
        }
        iterator = consumes.iterator();
        while (iterator.hasNext()) {
            Consumes consumesEntry = (Consumes)iterator.next();
            writer.startElement("consumes");
            this.addQNameAttribute((XMLWriter)writer, "interface-name", consumesEntry.getInterfaceName(), namespaceMap);
            this.addQNameAttribute((XMLWriter)writer, "service-name", consumesEntry.getServiceName(), namespaceMap);
            this.addStringAttribute((XMLWriter)writer, "endpoint-name", consumesEntry.getEndpointName());
            writer.endElement();
        }
        writer.endElement();
        writer.endElement();
        this.close(w);
    }

    private void close(Writer closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

