/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.maven.plugin.jbi;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.servicemix.maven.plugin.jbi.AbstractJbiMojo;
import org.apache.servicemix.maven.plugin.jbi.JbiPluginException;
import org.apache.servicemix.maven.plugin.jbi.JbiResolutionListener;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public class GenerateComponentMojo
extends AbstractJbiMojo {
    private File outputDirectory;
    private String finalName;
    private String installerName;
    private JarArchiver jarArchiver;
    private File jbiSourceDirectory;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)" ======= GenerateInstallerMojo settings =======");
        this.getLog().debug((CharSequence)("workDirectory[" + this.workDirectory + "]"));
        this.getLog().debug((CharSequence)("installerName[" + this.installerName + "]"));
        this.getLog().debug((CharSequence)("jbiSourceDirectory[" + this.jbiSourceDirectory + "]"));
        try {
            this.createUnpackedInstaller();
            File installerFile = new File(this.outputDirectory, this.installerName);
            this.createArchive(installerFile);
            this.projectHelper.attachArtifact(this.project, "zip", "installer", new File(this.outputDirectory, this.installerName));
        }
        catch (JbiPluginException e) {
            throw new MojoExecutionException("Failed to create installer", (Exception)e);
        }
    }

    private void createArchive(File installerFile) throws JbiPluginException {
        try {
            this.getLog().info((CharSequence)("Generating installer " + installerFile.getAbsolutePath()));
            MavenArchiver archiver = new MavenArchiver();
            archiver.setArchiver(this.jarArchiver);
            archiver.setOutputFile(installerFile);
            this.jarArchiver.addDirectory(this.workDirectory);
            if (this.jbiSourceDirectory.isDirectory()) {
                this.jarArchiver.addDirectory(this.jbiSourceDirectory, null, DirectoryScanner.DEFAULTEXCLUDES);
            }
            archiver.createArchive(this.getProject(), this.archive);
        }
        catch (ArchiverException e) {
            throw new JbiPluginException("Error creating assembly: " + e.getMessage(), e);
        }
        catch (ManifestException e) {
            throw new JbiPluginException("Error creating assembly: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new JbiPluginException("Error creating assembly: " + e.getMessage(), e);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new JbiPluginException("Error creating assembly: " + e.getMessage(), e);
        }
    }

    private void createUnpackedInstaller() throws JbiPluginException {
        Artifact artifact;
        if (!this.workDirectory.isDirectory() && !this.workDirectory.mkdirs()) {
            throw new JbiPluginException("Unable to create work directory: " + this.workDirectory);
        }
        File projectArtifact = new File(this.outputDirectory, this.finalName + ".jar");
        try {
            FileUtils.copyFileToDirectory((File)projectArtifact, (File)new File(this.workDirectory, "lib"));
        }
        catch (IOException e) {
            throw new JbiPluginException("Unable to copy file " + projectArtifact, e);
        }
        ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
        JbiResolutionListener listener = this.resolveProject();
        HashSet<Artifact> includes = new HashSet<Artifact>();
        Iterator iter = this.project.getArtifacts().iterator();
        while (iter.hasNext()) {
            String type;
            artifact = (Artifact)iter.next();
            if (artifact.isOptional() || !filter.include(artifact)) continue;
            MavenProject project = null;
            try {
                project = this.projectBuilder.buildFromRepository(artifact, this.remoteRepos, this.localRepo);
            }
            catch (ProjectBuildingException e) {
                this.getLog().warn((CharSequence)("Unable to determine packaging for dependency : " + artifact.getArtifactId() + " assuming jar"));
            }
            String string = type = project != null ? project.getPackaging() : artifact.getType();
            if ("jbi-shared-library".equals(type)) {
                this.removeBranch(listener, artifact);
                continue;
            }
            if (!"jar".equals(type)) continue;
            includes.add(artifact);
        }
        iter = this.retainArtifacts(includes, listener).iterator();
        while (iter.hasNext()) {
            artifact = (Artifact)iter.next();
            try {
                this.getLog().info((CharSequence)("Including: " + artifact));
                FileUtils.copyFileToDirectory((File)artifact.getFile(), (File)new File(this.workDirectory, "lib"));
            }
            catch (IOException e) {
                throw new JbiPluginException("Unable to copy file " + artifact.getFile(), e);
            }
        }
    }
}

