/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.unix;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.sshd.agent.unix.AprLibrary;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Channel;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.server.channel.AbstractServerChannel;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.jni.Local;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.Socket;

public class ChannelAgentForwarding
extends AbstractServerChannel {
    private String authSocket;
    private long pool;
    private long handle;
    private Thread thread;
    private OutputStream out;

    protected OpenFuture doInit(Buffer buffer) {
        DefaultOpenFuture f = new DefaultOpenFuture(this);
        try {
            this.out = new ChannelOutputStream(this, this.remoteWindow, this.log, 94);
            this.authSocket = this.session.getFactoryManager().getProperties().get("SSH_AUTH_SOCK");
            this.pool = Pool.create((long)AprLibrary.getInstance().getRootPool());
            this.handle = Local.create((String)this.authSocket, (long)this.pool);
            int result = Local.connect((long)this.handle, (long)0L);
            if (result != 0) {
                this.throwException(result);
            }
            this.thread = new Thread(){

                public void run() {
                    try {
                        byte[] buf = new byte[1024];
                        while (true) {
                            int len;
                            if ((len = Socket.recv((long)ChannelAgentForwarding.this.handle, (byte[])buf, (int)0, (int)buf.length)) <= 0) {
                                continue;
                            }
                            ChannelAgentForwarding.this.out.write(buf, 0, len);
                            ChannelAgentForwarding.this.out.flush();
                        }
                    }
                    catch (IOException e) {
                        ChannelAgentForwarding.this.close(true);
                        return;
                    }
                }
            };
            this.thread.start();
            f.setOpened();
        }
        catch (Exception e) {
            f.setException(e);
        }
        return f;
    }

    private void closeImmediately0() {
        super.close(true);
        Socket.close((long)this.handle);
    }

    public CloseFuture close(boolean immediately) {
        return (CloseFuture)super.close(immediately).addListener(new SshFutureListener(){

            public void operationComplete(SshFuture sshFuture) {
                ChannelAgentForwarding.this.closeImmediately0();
            }
        });
    }

    public void handleEof() throws IOException {
        super.handleEof();
    }

    protected void doWriteData(byte[] data, int off, int len) throws IOException {
        int result = Socket.send((long)this.handle, (byte[])data, (int)off, (int)len);
        if (result < 0) {
            this.throwException(result);
        }
    }

    protected void doWriteExtendedData(byte[] data, int off, int len) throws IOException {
        throw new UnsupportedOperationException("AgentForward channel does not support extended data");
    }

    private void throwException(int code) throws IOException {
        throw new IOException(Error.strerror((int)(-code)) + " (code: " + code + ")");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements NamedFactory<Channel> {
        @Override
        public String getName() {
            return "auth-agent@openssh.com";
        }

        @Override
        public Channel create() {
            return new ChannelAgentForwarding();
        }
    }
}

