/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.keyprovider;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collections;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.util.SecurityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGeneratorHostKeyProvider
extends AbstractKeyPairProvider {
    private String path;
    private String algorithm = "DSA";
    private int keySize;
    private AlgorithmParameterSpec keySpec;
    private KeyPair keyPair;

    protected AbstractGeneratorHostKeyProvider() {
    }

    protected AbstractGeneratorHostKeyProvider(String path) {
        this.path = path;
    }

    protected AbstractGeneratorHostKeyProvider(String path, String algorithm) {
        this.path = path;
        this.algorithm = algorithm;
    }

    protected AbstractGeneratorHostKeyProvider(String path, String algorithm, int keySize) {
        this.path = path;
        this.algorithm = algorithm;
        this.keySize = keySize;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public AlgorithmParameterSpec getKeySpec() {
        return this.keySpec;
    }

    public void setKeySpec(AlgorithmParameterSpec keySpec) {
        this.keySpec = keySpec;
    }

    protected abstract KeyPair doReadKeyPair(InputStream var1) throws Exception;

    protected abstract void doWriteKeyPair(KeyPair var1, OutputStream var2) throws Exception;

    @Override
    public synchronized Iterable<KeyPair> loadKeys() {
        if (this.keyPair == null) {
            File f;
            if (this.path != null && (f = new File(this.path)).exists() && f.isFile()) {
                this.keyPair = this.readKeyPair(f);
            }
            if (this.keyPair == null) {
                this.keyPair = this.generateKeyPair(this.algorithm);
                if (this.keyPair != null && this.path != null) {
                    this.writeKeyPair(this.keyPair, new File(this.path));
                }
            }
            if (this.keyPair == null) {
                return Collections.emptyList();
            }
        }
        return Collections.singleton(this.keyPair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyPair readKeyPair(File f) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            KeyPair keyPair = this.doReadKeyPair(is);
            Object var5_5 = null;
            this.close(is);
            return keyPair;
        }
        catch (Exception e) {
            try {
                this.log.warn("Unable to read key {}: {}", (Object)this.path, (Object)e);
                Object var5_6 = null;
                this.close(is);
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.close(is);
                throw throwable;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeKeyPair(KeyPair kp, File f) {
        FileOutputStream os = null;
        try {
            try {
                os = new FileOutputStream(f);
                this.doWriteKeyPair(kp, os);
            }
            catch (Exception e) {
                this.log.warn("Unable to write key {}: {}", (Object)this.path, (Object)e);
                Object var6_5 = null;
                this.close(os);
            }
            Object var6_4 = null;
            this.close(os);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.close(os);
            throw throwable;
        }
    }

    private KeyPair generateKeyPair(String algorithm) {
        try {
            KeyPairGenerator generator = SecurityUtils.getKeyPairGenerator(algorithm);
            if (this.keySpec != null) {
                generator.initialize(this.keySpec);
            } else if (this.keySize != 0) {
                generator.initialize(this.keySize);
            }
            this.log.info("Generating host key...");
            KeyPair kp = generator.generateKeyPair();
            return kp;
        }
        catch (Exception e) {
            this.log.warn("Unable to generate keypair", (Throwable)e);
            return null;
        }
    }

    private void close(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

