/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.osgi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.xbean.osgi.Artifact;
import org.apache.xbean.osgi.Project;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class MavenBundleManager {
    private final BundleContext bundleContext;
    private final File localRepository;

    public MavenBundleManager(BundleContext bundleContext, File localRepository) {
        this.bundleContext = bundleContext;
        this.localRepository = localRepository;
    }

    public Project loadProject(Artifact artifact) {
        if (artifact instanceof Project) {
            return (Project)artifact;
        }
        return new Project(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), Collections.EMPTY_SET);
    }

    public Project loadProject(String groupId, String artifactId, String version) {
        return new Project(groupId, artifactId, version, "jar", Collections.EMPTY_SET);
    }

    public Bundle installBundle(String groupId, String artifactId, String version) throws Exception {
        return this.installBundle(this.loadProject(groupId, artifactId, version));
    }

    public Bundle installBundle(Artifact artifact) throws Exception {
        String symbolicName = artifact.getGroupId() + "." + artifact.getArtifactId();
        String bundleVersion = MavenBundleManager.coerceToOsgiVersion(artifact.getVersion());
        Bundle[] bundles = this.bundleContext.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            Bundle bundle = bundles[i];
            if (!symbolicName.equals(bundle.getSymbolicName()) || !bundleVersion.equals(bundle.getHeaders().get("Bundle-Version"))) continue;
            return bundle;
        }
        Project project = this.loadProject(artifact);
        Manifest manifest = this.createOsgiManifest(project);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JarOutputStream jarOut = new JarOutputStream((OutputStream)out, manifest);
        jarOut.close();
        out.close();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        Bundle bundle = this.bundleContext.installBundle(symbolicName, (InputStream)in);
        for (Artifact dependency : project.getDependencies()) {
            this.installBundle(dependency);
        }
        return bundle;
    }

    public Manifest createOsgiManifest(Project project) throws IOException {
        String groupId = project.getGroupId();
        String artifactId = project.getArtifactId();
        String version = project.getVersion();
        String jar = groupId.replace('.', '/') + "/" + artifactId + "/" + version + "/" + project.getJar();
        StringBuffer requireBundle = new StringBuffer();
        for (Artifact dependency : project.getDependencies()) {
            if (requireBundle.length() > 0) {
                requireBundle.append(',');
            }
            requireBundle.append(dependency.getGroupId()).append('.').append(dependency.getArtifactId());
            requireBundle.append(";visibility:=reexport;bundle-version:=").append(MavenBundleManager.coerceToOsgiVersion(dependency.getVersion()));
        }
        String jarPath = new File(this.localRepository, jar).getAbsolutePath();
        StringBuffer exports = MavenBundleManager.createExportList(jarPath);
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attributes.putValue("Bundle-ManifestVersion", "2");
        attributes.putValue("Bundle-Vendor", groupId);
        attributes.putValue("Bundle-Name", artifactId);
        attributes.putValue("Bundle-Version", MavenBundleManager.coerceToOsgiVersion(version));
        attributes.putValue("Bundle-SymbolicName", groupId + "." + artifactId);
        attributes.putValue("Eclipse-AutoStart", "true");
        attributes.putValue("Bundle-ClassPath", ".,external:" + jarPath);
        attributes.putValue("Export-Package", exports.toString());
        if (requireBundle != null && requireBundle.length() > 0) {
            attributes.putValue("Require-Bundle", requireBundle.toString());
        }
        return manifest;
    }

    private static String coerceToOsgiVersion(String version) {
        int partsFound = 0;
        String[] versionParts = new String[]{"0", "0", "0"};
        StringBuffer qualifier = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(version, ".-");
        while (stringTokenizer.hasMoreTokens()) {
            String part = stringTokenizer.nextToken();
            if (partsFound < 4) {
                try {
                    Integer.parseInt(part);
                    versionParts[partsFound++] = part;
                }
                catch (NumberFormatException e) {
                    partsFound = 4;
                    qualifier.append(MavenBundleManager.coerceToOsgiQualifier(part));
                }
                continue;
            }
            if (qualifier.length() > 0) {
                qualifier.append("_");
            }
            qualifier.append(MavenBundleManager.coerceToOsgiQualifier(part));
        }
        StringBuffer osgiVersion = new StringBuffer();
        osgiVersion.append(versionParts[0]).append(".").append(versionParts[1]).append(".").append(versionParts[2]);
        if (qualifier.length() > 0) {
            osgiVersion.append(".").append(qualifier);
        }
        return osgiVersion.toString();
    }

    private static String coerceToOsgiQualifier(String qualifier) {
        char[] chars = qualifier.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (Character.isLetterOrDigit(c) || c == '_' || c == '-') continue;
            chars[i] = 95;
        }
        return new String(chars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StringBuffer createExportList(String jarPath) throws IOException {
        HashSet<String> packages = new HashSet<String>();
        FileInputStream in = null;
        try {
            in = new FileInputStream(jarPath);
            JarInputStream jarIn = new JarInputStream(in);
            JarEntry jarEntry = jarIn.getNextJarEntry();
            while (jarEntry != null) {
                int index;
                String packageName = jarEntry.getName();
                if (!jarEntry.isDirectory() && (index = packageName.lastIndexOf("/")) > 0 && !(packageName = packageName.substring(0, index)).equals("META-INF")) {
                    packageName = packageName.replace('/', '.');
                    packages.add(packageName);
                }
                jarEntry = jarIn.getNextJarEntry();
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        StringBuffer exports = new StringBuffer();
        for (String packageName : packages) {
            if (exports.length() > 0) {
                exports.append(";");
            }
            exports.append(packageName);
        }
        return exports;
    }
}

