/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.osgi;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.xbean.osgi.Artifact;

public class Project
implements Artifact {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String type;
    private final String jar;
    private final Set dependencies;

    public Project(String groupId, String artifactId, String version, String type, Set dependencies) {
        this(groupId, artifactId, version, type, artifactId + "-" + version + "." + type, dependencies);
    }

    public Project(String groupId, String artifactId, String version, String type, String jar, Set dependencies) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = type;
        this.jar = jar;
        HashSet<Artifact> deps = new HashSet<Artifact>();
        for (Artifact dependency : dependencies) {
            deps.add(dependency);
        }
        this.dependencies = Collections.unmodifiableSet(deps);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    public String getJar() {
        return this.jar;
    }

    public Set getDependencies() {
        return this.dependencies;
    }
}

