/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.jetty.start.Config;

public class Monitor
extends Thread {
    private Process _process;
    private final int _port;
    private final String _key;
    ServerSocket _socket;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Monitor(int port, String key) {
        try {
            if (port < 0) {
                return;
            }
            this.setDaemon(true);
            this.setName("StopMonitor");
            this._socket = new ServerSocket(port, 1, InetAddress.getByName("127.0.0.1"));
            if (port == 0) {
                port = this._socket.getLocalPort();
                System.out.println(port);
            }
            if (key == null) {
                key = Long.toString((long)(9.223372036854776E18 * Math.random() + (double)this.hashCode() + (double)System.currentTimeMillis()), 36);
                System.out.println("STOP.KEY=" + key);
            }
        }
        catch (Exception e) {
            Config.debug(e);
            System.err.println("Error binding monitor port " + port + ": " + e.toString());
        }
        finally {
            this._port = port;
            this._key = key;
        }
        if (this._socket != null) {
            this.start();
        } else {
            System.err.println("WARN: Not listening on monitor port: " + this._port);
        }
    }

    public Process getProcess() {
        return this._process;
    }

    public void setProcess(Process process) {
        this._process = process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Socket socket = null;
            try {
                socket = this._socket.accept();
                LineNumberReader lin = new LineNumberReader(new InputStreamReader(socket.getInputStream()));
                String key = lin.readLine();
                if (!this._key.equals(key)) {
                    System.err.println("Ignoring command with incorrect key");
                    continue;
                }
                String cmd = lin.readLine();
                Config.debug("command=" + cmd);
                if ("stop".equals(cmd)) {
                    try {
                        socket.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        this._socket.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (this._process != null) {
                        try {
                            this._process.destroy();
                            this._process.waitFor();
                        }
                        catch (InterruptedException e) {
                            System.err.println("Interrupted waiting for child to terminate");
                        }
                    }
                    System.exit(0);
                    continue;
                }
                if (!"status".equals(cmd)) continue;
                socket.getOutputStream().write("OK\r\n".getBytes());
                socket.getOutputStream().flush();
                continue;
            }
            catch (Exception e) {
                Config.debug(e);
                System.err.println(e.toString());
                continue;
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {}
                }
                socket = null;
                continue;
            }
            break;
        }
    }
}

