/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeaderValues;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.BufferCache;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.View;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpFieldsTest {
    @Test
    public void testPut() throws Exception {
        HttpFields header = new HttpFields();
        header.put("name0", "value0");
        header.put("name1", "value1");
        Assert.assertEquals((Object)"value0", (Object)header.getStringField("name0"));
        Assert.assertEquals((Object)"value1", (Object)header.getStringField("name1"));
        Assert.assertNull((Object)header.getStringField("name2"));
        int matches = 0;
        Enumeration e = header.getFieldNames();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if ("name0".equals(o)) {
                ++matches;
            }
            if (!"name1".equals(o)) continue;
            ++matches;
        }
        Assert.assertEquals((long)2L, (long)matches);
        e = header.getValues("name0");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value0");
        Assert.assertEquals((Object)false, (Object)e.hasMoreElements());
    }

    @Test
    public void testGet() throws Exception {
        HttpFields header = new HttpFields();
        header.put("name0", "value0");
        header.put((Buffer)new ByteArrayBuffer("name1"), (Buffer)new ByteArrayBuffer("value1"));
        Assert.assertEquals((Object)"value0", (Object)header.getStringField("name0"));
        Assert.assertEquals((Object)"value0", (Object)header.getStringField("Name0"));
        Assert.assertEquals((Object)"value1", (Object)header.getStringField("name1"));
        Assert.assertEquals((Object)"value1", (Object)header.getStringField("Name1"));
    }

    @Test
    public void testCRLF() throws Exception {
        HttpFields header = new HttpFields();
        header.put("name0", "value\r\n0");
        header.put("name\r\n1", "value1");
        header.put("name:2", "value:\r\n2");
        ByteArrayBuffer buffer = new ByteArrayBuffer(1024);
        header.putTo((Buffer)buffer);
        Assert.assertTrue((boolean)buffer.toString().contains("name0: value0"));
        Assert.assertTrue((boolean)buffer.toString().contains("name1: value1"));
        Assert.assertTrue((boolean)buffer.toString().contains("name2: value:2"));
    }

    @Test
    public void testCachedPut() throws Exception {
        HttpFields header = new HttpFields();
        header.put("Connection", "keep-alive");
        Assert.assertEquals((Object)"keep-alive", (Object)header.getStringField("Connection"));
        int matches = 0;
        Enumeration e = header.getFieldNames();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o == "Content-Type") {
                ++matches;
            }
            if (o != "Connection") continue;
            ++matches;
        }
        Assert.assertEquals((long)1L, (long)matches);
    }

    @Test
    public void testRePut() throws Exception {
        HttpFields header = new HttpFields();
        header.put("name0", "value0");
        header.put("name1", "xxxxxx");
        header.put("name2", "value2");
        Assert.assertEquals((Object)"value0", (Object)header.getStringField("name0"));
        Assert.assertEquals((Object)"xxxxxx", (Object)header.getStringField("name1"));
        Assert.assertEquals((Object)"value2", (Object)header.getStringField("name2"));
        header.put("name1", "value1");
        Assert.assertEquals((Object)"value0", (Object)header.getStringField("name0"));
        Assert.assertEquals((Object)"value1", (Object)header.getStringField("name1"));
        Assert.assertEquals((Object)"value2", (Object)header.getStringField("name2"));
        Assert.assertNull((Object)header.getStringField("name3"));
        int matches = 0;
        Enumeration e = header.getFieldNames();
        while (e.hasMoreElements()) {
            String o = (String)e.nextElement();
            if ("name0".equals(o)) {
                ++matches;
            }
            if ("name1".equals(o)) {
                ++matches;
            }
            if (!"name2".equals(o)) continue;
            ++matches;
        }
        Assert.assertEquals((long)3L, (long)matches);
        e = header.getValues("name1");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value1");
        Assert.assertEquals((Object)false, (Object)e.hasMoreElements());
    }

    @Test
    public void testRemovePut() throws Exception {
        HttpFields header = new HttpFields();
        header.put("name0", "value0");
        header.put("name1", "value1");
        header.put("name2", "value2");
        Assert.assertEquals((Object)"value0", (Object)header.getStringField("name0"));
        Assert.assertEquals((Object)"value1", (Object)header.getStringField("name1"));
        Assert.assertEquals((Object)"value2", (Object)header.getStringField("name2"));
        header.remove("name1");
        Assert.assertEquals((Object)"value0", (Object)header.getStringField("name0"));
        Assert.assertNull((Object)header.getStringField("name1"));
        Assert.assertEquals((Object)"value2", (Object)header.getStringField("name2"));
        Assert.assertNull((Object)header.getStringField("name3"));
        int matches = 0;
        Enumeration e = header.getFieldNames();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if ("name0".equals(o)) {
                ++matches;
            }
            if ("name1".equals(o)) {
                ++matches;
            }
            if (!"name2".equals(o)) continue;
            ++matches;
        }
        Assert.assertEquals((long)2L, (long)matches);
        e = header.getValues("name1");
        Assert.assertEquals((Object)false, (Object)e.hasMoreElements());
    }

    @Test
    public void testAdd() throws Exception {
        HttpFields fields = new HttpFields();
        fields.add("name0", "value0");
        fields.add("name1", "valueA");
        fields.add("name2", "value2");
        Assert.assertEquals((Object)"value0", (Object)fields.getStringField("name0"));
        Assert.assertEquals((Object)"valueA", (Object)fields.getStringField("name1"));
        Assert.assertEquals((Object)"value2", (Object)fields.getStringField("name2"));
        fields.add("name1", "valueB");
        Assert.assertEquals((Object)"value0", (Object)fields.getStringField("name0"));
        Assert.assertEquals((Object)"valueA", (Object)fields.getStringField("name1"));
        Assert.assertEquals((Object)"value2", (Object)fields.getStringField("name2"));
        Assert.assertNull((Object)fields.getStringField("name3"));
        int matches = 0;
        Enumeration e = fields.getFieldNames();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if ("name0".equals(o)) {
                ++matches;
            }
            if ("name1".equals(o)) {
                ++matches;
            }
            if (!"name2".equals(o)) continue;
            ++matches;
        }
        Assert.assertEquals((long)3L, (long)matches);
        e = fields.getValues("name1");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"valueA");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"valueB");
        Assert.assertEquals((Object)false, (Object)e.hasMoreElements());
    }

    @Test
    public void testReuse() throws Exception {
        HttpFields header = new HttpFields();
        ByteArrayBuffer n1 = new ByteArrayBuffer("name1");
        ByteArrayBuffer va = new ByteArrayBuffer("value1");
        ByteArrayBuffer vb = new ByteArrayBuffer(10);
        vb.put((byte)118);
        vb.put((byte)97);
        vb.put((byte)108);
        vb.put((byte)117);
        vb.put((byte)101);
        vb.put((byte)49);
        header.put("name0", "value0");
        header.put((Buffer)n1, (Buffer)va);
        header.put("name2", "value2");
        Assert.assertEquals((Object)"value0", (Object)header.getStringField("name0"));
        Assert.assertEquals((Object)"value1", (Object)header.getStringField("name1"));
        Assert.assertEquals((Object)"value2", (Object)header.getStringField("name2"));
        Assert.assertNull((Object)header.getStringField("name3"));
        header.remove((Buffer)n1);
        Assert.assertNull((Object)header.getStringField("name1"));
        header.put((Buffer)n1, (Buffer)vb);
        Assert.assertEquals((Object)"value1", (Object)header.getStringField("name1"));
        int matches = 0;
        Enumeration e = header.getFieldNames();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if ("name0".equals(o)) {
                ++matches;
            }
            if ("name1".equals(o)) {
                ++matches;
            }
            if (!"name2".equals(o)) continue;
            ++matches;
        }
        Assert.assertEquals((long)3L, (long)matches);
        e = header.getValues("name1");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value1");
        Assert.assertEquals((Object)false, (Object)e.hasMoreElements());
    }

    @Test
    public void testCase() throws Exception {
        HttpFields fields = new HttpFields();
        byte[] b = "Message-IDmessage-idvalueVALUE".getBytes();
        ByteArrayBuffer buf = new ByteArrayBuffer(512);
        buf.put(b);
        View.CaseInsensitive headUC = new View.CaseInsensitive((Buffer)buf);
        View.CaseInsensitive headLC = new View.CaseInsensitive((Buffer)buf);
        View valUC = new View((Buffer)buf);
        View valLC = new View((Buffer)buf);
        headUC.update(0, 10);
        headLC.update(10, 20);
        valUC.update(20, 25);
        valLC.update(25, 30);
        fields.add("header", "value");
        fields.add((Buffer)headUC, (Buffer)valLC);
        fields.add("other", "data");
        Set<String> s = this.enum2set(fields.getFieldNames());
        Assert.assertEquals((long)3L, (long)s.size());
        Assert.assertTrue((boolean)s.contains("message-id"));
        Assert.assertEquals((Object)"value", (Object)fields.getStringField("message-id").toLowerCase());
        Assert.assertEquals((Object)"value", (Object)fields.getStringField("Message-ID").toLowerCase());
        fields.clear();
        fields.add("header", "value");
        fields.add((Buffer)headLC, (Buffer)valLC);
        fields.add("other", "data");
        s = this.enum2set(fields.getFieldNames());
        Assert.assertEquals((long)3L, (long)s.size());
        Assert.assertTrue((boolean)s.contains("message-id"));
        Assert.assertEquals((Object)"value", (Object)fields.getStringField("Message-ID").toLowerCase());
        Assert.assertEquals((Object)"value", (Object)fields.getStringField("message-id").toLowerCase());
        fields.clear();
        fields.add("header", "value");
        fields.add((Buffer)headUC, (Buffer)valUC);
        fields.add("other", "data");
        s = this.enum2set(fields.getFieldNames());
        Assert.assertEquals((long)3L, (long)s.size());
        Assert.assertTrue((boolean)s.contains("message-id"));
        Assert.assertEquals((Object)"value", (Object)fields.getStringField("message-id").toLowerCase());
        Assert.assertEquals((Object)"value", (Object)fields.getStringField("Message-ID").toLowerCase());
        fields.clear();
        fields.add("header", "value");
        fields.add((Buffer)headLC, (Buffer)valUC);
        fields.add("other", "data");
        s = this.enum2set(fields.getFieldNames());
        Assert.assertEquals((long)3L, (long)s.size());
        Assert.assertTrue((boolean)s.contains("message-id"));
        Assert.assertEquals((Object)"value", (Object)fields.getStringField("Message-ID").toLowerCase());
        Assert.assertEquals((Object)"value", (Object)fields.getStringField("message-id").toLowerCase());
    }

    @Test
    public void testHttpHeaderValues() throws Exception {
        Assert.assertTrue((((BufferCache.CachedBuffer)HttpHeaderValues.CACHE.lookup("unknown value")).getOrdinal() < 0 ? 1 : 0) != 0);
        Assert.assertTrue((((BufferCache.CachedBuffer)HttpHeaderValues.CACHE.lookup("close")).getOrdinal() >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSetCookie() throws Exception {
        HttpFields fields = new HttpFields();
        fields.addSetCookie("minimal", "value", null, null, -1L, null, false, false, -1);
        Assert.assertEquals((Object)"minimal=value", (Object)fields.getStringField("Set-Cookie"));
        fields.clear();
        fields.addSetCookie("everything", "wrong", "wrong", "wrong", 0L, "to be replaced", true, true, 0);
        fields.addSetCookie("everything", "value", "domain", "path", 0L, "comment", true, true, 0);
        Assert.assertEquals((Object)"everything=value;Path=path;Domain=domain;Expires=Thu, 01-Jan-1970 00:00:00 GMT;Secure;HttpOnly", (Object)fields.getStringField("Set-Cookie"));
        Enumeration e = fields.getValues("Set-Cookie");
        Assert.assertTrue((boolean)e.hasMoreElements());
        Assert.assertEquals((Object)"everything=value;Path=path;Domain=domain;Expires=Thu, 01-Jan-1970 00:00:00 GMT;Secure;HttpOnly", e.nextElement());
        Assert.assertFalse((boolean)e.hasMoreElements());
        Assert.assertEquals((Object)"Thu, 01 Jan 1970 00:00:00 GMT", (Object)fields.getStringField("Expires"));
        fields.clear();
        fields.addSetCookie("ev erything", "va lue", "do main", "pa th", 1L, "co mment", true, true, 2);
        String setCookie = fields.getStringField("Set-Cookie");
        Assert.assertTrue((boolean)setCookie.startsWith("\"ev erything\"=\"va lue\";Version=1;Comment=\"co mment\";Path=\"pa th\";Domain=\"do main\";Expires="));
        Assert.assertTrue((boolean)setCookie.endsWith("GMT;Max-Age=1;Secure;HttpOnly"));
        fields.clear();
        fields.addSetCookie("name", "value", null, null, -1L, null, false, false, 0);
        setCookie = fields.getStringField("Set-Cookie");
        Assert.assertEquals((long)-1L, (long)setCookie.indexOf("Version="));
        fields.clear();
        fields.addSetCookie("name", "v a l u e", null, null, -1L, null, false, false, 0);
        setCookie = fields.getStringField("Set-Cookie");
        Assert.assertEquals((long)17L, (long)setCookie.indexOf("Version=1"));
        fields.clear();
        fields.addSetCookie("json", "{\"services\":[\"cwa\", \"aa\"]}", null, null, -1L, null, false, false, -1);
        Assert.assertEquals((Object)"json=\"{\\\"services\\\":[\\\"cwa\\\", \\\"aa\\\"]}\"", (Object)fields.getStringField("Set-Cookie"));
        fields.clear();
        fields.addSetCookie("name", "value", "domain", null, -1L, null, false, false, -1);
        fields.addSetCookie("name", "other", "domain", null, -1L, null, false, false, -1);
        Assert.assertEquals((Object)"name=other;Domain=domain", (Object)fields.getStringField("Set-Cookie"));
        fields.addSetCookie("name", "more", "domain", null, -1L, null, false, false, -1);
        Assert.assertEquals((Object)"name=more;Domain=domain", (Object)fields.getStringField("Set-Cookie"));
        fields.addSetCookie("foo", "bar", "domain", null, -1L, null, false, false, -1);
        fields.addSetCookie("foo", "bob", "domain", null, -1L, null, false, false, -1);
        Assert.assertEquals((Object)"name=more;Domain=domain", (Object)fields.getStringField("Set-Cookie"));
        e = fields.getValues("Set-Cookie");
        Assert.assertEquals((Object)"name=more;Domain=domain", e.nextElement());
        Assert.assertEquals((Object)"foo=bob;Domain=domain", e.nextElement());
        fields = new HttpFields(0);
        fields.addSetCookie("name", "value==", null, null, -1L, null, false, false, 0);
        setCookie = fields.getStringField("Set-Cookie");
        Assert.assertEquals((Object)"name=value==", (Object)setCookie);
    }

    private Set<String> enum2set(Enumeration<String> e) {
        HashSet<String> s = new HashSet<String>();
        while (e.hasMoreElements()) {
            s.add(e.nextElement().toLowerCase());
        }
        return s;
    }

    @Test
    public void testDateFields() throws Exception {
        HttpFields fields = new HttpFields();
        fields.put("D0", "Wed, 31 Dec 1969 23:59:59 GMT");
        fields.put("D1", "Fri, 31 Dec 1999 23:59:59 GMT");
        fields.put("D2", "Friday, 31-Dec-99 23:59:59 GMT");
        fields.put("D3", "Fri Dec 31 23:59:59 1999");
        fields.put("D4", "Mon Jan 1 2000 00:00:01");
        fields.put("D5", "Tue Feb 29 2000 12:00:00");
        long d1 = fields.getDateField("D1");
        long d0 = fields.getDateField("D0");
        long d2 = fields.getDateField("D2");
        long d3 = fields.getDateField("D3");
        long d4 = fields.getDateField("D4");
        long d5 = fields.getDateField("D5");
        Assert.assertTrue((d0 != -1L ? 1 : 0) != 0);
        Assert.assertTrue((d1 > 0L ? 1 : 0) != 0);
        Assert.assertTrue((d2 > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)d1, (long)d2);
        Assert.assertEquals((long)d2, (long)d3);
        Assert.assertEquals((long)(d3 + 2000L), (long)d4);
        Assert.assertEquals((long)951825600000L, (long)d5);
        d1 = fields.getDateField("D1");
        d2 = fields.getDateField("D2");
        d3 = fields.getDateField("D3");
        d4 = fields.getDateField("D4");
        d5 = fields.getDateField("D5");
        Assert.assertTrue((d1 > 0L ? 1 : 0) != 0);
        Assert.assertTrue((d2 > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)d1, (long)d2);
        Assert.assertEquals((long)d2, (long)d3);
        Assert.assertEquals((long)(d3 + 2000L), (long)d4);
        Assert.assertEquals((long)951825600000L, (long)d5);
        fields.putDateField("D2", d1);
        Assert.assertEquals((Object)"Fri, 31 Dec 1999 23:59:59 GMT", (Object)fields.getStringField("D2"));
    }

    @Test
    public void testNegDateFields() throws Exception {
        HttpFields fields = new HttpFields();
        fields.putDateField("Dzero", 0L);
        Assert.assertEquals((Object)"Thu, 01 Jan 1970 00:00:00 GMT", (Object)fields.getStringField("Dzero"));
        fields.putDateField("Dminus", -1L);
        Assert.assertEquals((Object)"Wed, 31 Dec 1969 23:59:59 GMT", (Object)fields.getStringField("Dminus"));
        fields.putDateField("Dminus", -1000L);
        Assert.assertEquals((Object)"Wed, 31 Dec 1969 23:59:59 GMT", (Object)fields.getStringField("Dminus"));
        fields.putDateField("Dancient", Long.MIN_VALUE);
        Assert.assertEquals((Object)"Sun, 02 Dec 55 16:47:04 GMT", (Object)fields.getStringField("Dancient"));
    }

    @Test
    public void testLongFields() throws Exception {
        HttpFields header = new HttpFields();
        header.put("I1", "42");
        header.put("I2", " 43 99");
        header.put("I3", "-44;");
        header.put("I4", " - 45abc");
        header.put("N1", " - ");
        header.put("N2", "xx");
        long i1 = header.getLongField("I1");
        long i2 = header.getLongField("I2");
        long i3 = header.getLongField("I3");
        long i4 = header.getLongField("I4");
        try {
            header.getLongField("N1");
            Assert.assertTrue((boolean)false);
        }
        catch (NumberFormatException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            header.getLongField("N2");
            Assert.assertTrue((boolean)false);
        }
        catch (NumberFormatException e) {
            Assert.assertTrue((boolean)true);
        }
        Assert.assertEquals((long)42L, (long)i1);
        Assert.assertEquals((long)43L, (long)i2);
        Assert.assertEquals((long)-44L, (long)i3);
        Assert.assertEquals((long)-45L, (long)i4);
        header.putLongField("I5", 46L);
        header.putLongField("I6", -47L);
        Assert.assertEquals((Object)"46", (Object)header.getStringField("I5"));
        Assert.assertEquals((Object)"-47", (Object)header.getStringField("I6"));
    }

    @Test
    public void testToString() throws Exception {
        HttpFields header = new HttpFields();
        header.put((Buffer)new ByteArrayBuffer("name0"), (Buffer)new View((Buffer)new ByteArrayBuffer("value0")));
        header.put((Buffer)new ByteArrayBuffer("name1"), (Buffer)new View((Buffer)new ByteArrayBuffer("value1".getBytes())));
        String s1 = header.toString();
        String s2 = header.toString();
        Assert.assertEquals((Object)s1, (Object)s2);
    }
}

