/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.IOException;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.ByteArrayEndPoint;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.SimpleBuffers;
import org.eclipse.jetty.io.View;
import org.junit.Assert;
import org.junit.Test;

public class HttpGeneratorClientTest {
    public static final String CONTENT = "The quick brown fox jumped over the lazy dog.\nNow is the time for all good men to come to the aid of the party\nThe moon is blue to a fish in love.\n";
    public static final String[] connect = new String[]{null, "keep-alive", "close"};
    private static final String[] headers = new String[]{"Content-Type", "Content-Length", "Connection", "Transfer-Encoding", "Other"};
    private final TR[] tr = new TR[]{new TR(null, null, null), new TR(null, null, "The quick brown fox jumped over the lazy dog.\nNow is the time for all good men to come to the aid of the party\nThe moon is blue to a fish in love.\n"), new TR(null, "" + "The quick brown fox jumped over the lazy dog.\nNow is the time for all good men to come to the aid of the party\nThe moon is blue to a fish in love.\n".length(), "The quick brown fox jumped over the lazy dog.\nNow is the time for all good men to come to the aid of the party\nThe moon is blue to a fish in love.\n"), new TR("text/html", null, null), new TR("text/html", null, "The quick brown fox jumped over the lazy dog.\nNow is the time for all good men to come to the aid of the party\nThe moon is blue to a fish in love.\n"), new TR("text/html", "" + "The quick brown fox jumped over the lazy dog.\nNow is the time for all good men to come to the aid of the party\nThe moon is blue to a fish in love.\n".length(), "The quick brown fox jumped over the lazy dog.\nNow is the time for all good men to come to the aid of the party\nThe moon is blue to a fish in love.\n")};
    private String content;
    private String f0;
    private String f1;
    private String f2;
    private String[] hdr;
    private String[] val;
    private int h;

    @Test
    public void testContentLength() throws Exception {
        ByteArrayBuffer bb = new ByteArrayBuffer(8096);
        ByteArrayBuffer sb = new ByteArrayBuffer(1500);
        ByteArrayEndPoint endp = new ByteArrayEndPoint(new byte[0], 4096);
        HttpGenerator generator = new HttpGenerator((Buffers)new SimpleBuffers((Buffer)sb, (Buffer)bb), (EndPoint)endp);
        generator.setRequest("GET", "/usr");
        HttpFields fields = new HttpFields();
        fields.add("Header", "Value");
        fields.add("Content-Type", "text/plain");
        String content = "The quick brown fox jumped over the lazy dog";
        fields.addLongField("Content-Length", (long)content.length());
        generator.completeHeader(fields, false);
        generator.addContent(new ByteArrayBuffer(content).asMutableBuffer(), true);
        generator.flushBuffer();
        generator.complete();
        generator.flushBuffer();
        String result = endp.getOut().toString().replace("\r\n", "|").replace('\r', '|').replace('\n', '|');
        Assert.assertEquals((Object)("GET /usr HTTP/1.1|Header: Value|Content-Type: text/plain|Content-Length: 44||" + content), (Object)result);
    }

    @Test
    public void testAutoContentLength() throws Exception {
        ByteArrayBuffer bb = new ByteArrayBuffer(8096);
        ByteArrayBuffer sb = new ByteArrayBuffer(1500);
        ByteArrayEndPoint endp = new ByteArrayEndPoint(new byte[0], 4096);
        HttpGenerator generator = new HttpGenerator((Buffers)new SimpleBuffers((Buffer)sb, (Buffer)bb), (EndPoint)endp);
        generator.setRequest("GET", "/usr");
        HttpFields fields = new HttpFields();
        fields.add("Header", "Value");
        fields.add("Content-Type", "text/plain");
        String content = "The quick brown fox jumped over the lazy dog";
        generator.addContent(new ByteArrayBuffer(content).asMutableBuffer(), true);
        generator.completeHeader(fields, true);
        generator.flushBuffer();
        generator.complete();
        generator.flushBuffer();
        String result = endp.getOut().toString().replace("\r\n", "|").replace('\r', '|').replace('\n', '|');
        Assert.assertEquals((Object)("GET /usr HTTP/1.1|Header: Value|Content-Type: text/plain|Content-Length: 44||" + content), (Object)result);
    }

    @Test
    public void testChunked() throws Exception {
        ByteArrayBuffer bb = new ByteArrayBuffer(8096);
        ByteArrayBuffer sb = new ByteArrayBuffer(1500);
        ByteArrayEndPoint endp = new ByteArrayEndPoint(new byte[0], 4096);
        HttpGenerator generator = new HttpGenerator((Buffers)new SimpleBuffers((Buffer)sb, (Buffer)bb), (EndPoint)endp);
        generator.setRequest("GET", "/usr");
        HttpFields fields = new HttpFields();
        fields.add("Header", "Value");
        fields.add("Content-Type", "text/plain");
        String content = "The quick brown fox jumped over the lazy dog";
        generator.completeHeader(fields, false);
        generator.addContent(new ByteArrayBuffer(content).asMutableBuffer(), false);
        generator.flushBuffer();
        generator.complete();
        generator.flushBuffer();
        String result = endp.getOut().toString().replace("\r\n", "|").replace('\r', '|').replace('\n', '|');
        Assert.assertEquals((Object)("GET /usr HTTP/1.1|Header: Value|Content-Type: text/plain|Transfer-Encoding: chunked||2C|" + content + "|0||"), (Object)result);
    }

    @Test
    public void testHTTP() throws Exception {
        ByteArrayBuffer bb = new ByteArrayBuffer(8096);
        ByteArrayBuffer sb = new ByteArrayBuffer(1500);
        HttpFields fields = new HttpFields();
        ByteArrayEndPoint endp = new ByteArrayEndPoint(new byte[0], 4096);
        HttpGenerator hb = new HttpGenerator((Buffers)new SimpleBuffers((Buffer)sb, (Buffer)bb), (EndPoint)endp);
        Handler handler = new Handler();
        HttpParser parser = null;
        for (int v = 9; v <= 11; ++v) {
            for (int r = 0; r < this.tr.length; ++r) {
                for (int chunks = 1; chunks <= 6; ++chunks) {
                    for (int c = 0; c < connect.length; ++c) {
                        String t = "v=" + v + ",r=" + r + ",chunks=" + chunks + ",c=" + c + ",tr=" + this.tr[r];
                        hb.reset(true);
                        endp.reset();
                        fields.clear();
                        try {
                            this.tr[r].build(v, hb, HttpGeneratorClientTest.connect[c], null, chunks, fields);
                        }
                        catch (IllegalStateException e) {
                            if (v < 10 || v == 10 && chunks > 2) continue;
                            System.err.println(t);
                            throw e;
                        }
                        String request = endp.getOut().toString();
                        Assert.assertTrue((String)t, (boolean)hb.isPersistent());
                        if (v == 9) {
                            Assert.assertEquals((String)t, (Object)"GET /context/path/info\r\n", (Object)request);
                            continue;
                        }
                        parser = new HttpParser((Buffer)new ByteArrayBuffer(request.getBytes()), (HttpParser.EventHandler)handler);
                        try {
                            parser.parse();
                        }
                        catch (IOException e) {
                            if (this.tr[r].body == null) continue;
                            throw e;
                        }
                        if (this.tr[r].body != null) {
                            Assert.assertEquals((String)t, (Object)this.tr[r].body, (Object)this.content);
                        }
                        if (v == 10) {
                            Assert.assertTrue((String)t, (hb.isPersistent() || this.tr[r].values[1] == null || c == 2 || c == 0 ? 1 : 0) != 0);
                        } else {
                            Assert.assertTrue((String)t, (hb.isPersistent() || c == 2 ? 1 : 0) != 0);
                        }
                        Assert.assertTrue((String)t, (this.tr[r].values[1] == null || this.content.length() == Integer.parseInt(this.tr[r].values[1]) ? 1 : 0) != 0);
                    }
                }
            }
        }
    }

    static /* synthetic */ String[] access$802(HttpGeneratorClientTest x0, String[] x1) {
        x0.hdr = x1;
        return x1;
    }

    static /* synthetic */ String[] access$902(HttpGeneratorClientTest x0, String[] x1) {
        x0.val = x1;
        return x1;
    }

    private class Handler
    extends HttpParser.EventHandler {
        private int index = 0;

        private Handler() {
        }

        public void content(Buffer ref) {
            if (this.index == 0) {
                HttpGeneratorClientTest.this.content = "";
            }
            HttpGeneratorClientTest.this.content = HttpGeneratorClientTest.this.content.substring(0, this.index) + ref;
            this.index += ref.length();
        }

        public void startRequest(Buffer tok0, Buffer tok1, Buffer tok2) {
            HttpGeneratorClientTest.this.h = -1;
            HttpGeneratorClientTest.access$802(HttpGeneratorClientTest.this, new String[9]);
            HttpGeneratorClientTest.access$902(HttpGeneratorClientTest.this, new String[9]);
            HttpGeneratorClientTest.this.f0 = tok0.toString();
            HttpGeneratorClientTest.this.f1 = tok1.toString();
            if (tok2 != null) {
                HttpGeneratorClientTest.this.f2 = tok2.toString();
            } else {
                HttpGeneratorClientTest.this.f2 = null;
            }
            this.index = 0;
        }

        public void startResponse(Buffer version, int status, Buffer reason) {
            HttpGeneratorClientTest.this.h = -1;
            HttpGeneratorClientTest.access$802(HttpGeneratorClientTest.this, new String[9]);
            HttpGeneratorClientTest.access$902(HttpGeneratorClientTest.this, new String[9]);
            HttpGeneratorClientTest.this.f0 = version.toString();
            HttpGeneratorClientTest.this.f1 = "" + status;
            if (reason != null) {
                HttpGeneratorClientTest.this.f2 = reason.toString();
            } else {
                HttpGeneratorClientTest.this.f2 = null;
            }
            this.index = 0;
        }

        public void parsedHeader(Buffer name, Buffer value) {
            ((HttpGeneratorClientTest)HttpGeneratorClientTest.this).hdr[++((HttpGeneratorClientTest)HttpGeneratorClientTest.this).h] = name.toString();
            ((HttpGeneratorClientTest)HttpGeneratorClientTest.this).val[((HttpGeneratorClientTest)HttpGeneratorClientTest.this).h] = value.toString();
        }

        public void headerComplete() {
            HttpGeneratorClientTest.this.content = null;
        }

        public void messageComplete(long contentLength) {
        }
    }

    private class TR {
        private String[] values = new String[HttpGeneratorClientTest.access$400().length];
        private String body;

        private TR(String ct, String cl, String content) {
            this.values[0] = ct;
            this.values[1] = cl;
            this.values[4] = "value";
            this.body = content;
        }

        private void build(int version, HttpGenerator hb, String connection, String te, int chunks, HttpFields fields) throws Exception {
            this.values[2] = connection;
            this.values[3] = te;
            hb.setRequest("GET", "/context/path/info");
            hb.setVersion(version);
            for (int i = 0; i < headers.length; ++i) {
                if (this.values[i] == null) continue;
                fields.put((Buffer)new ByteArrayBuffer(headers[i]), (Buffer)new ByteArrayBuffer(this.values[i]));
            }
            if (this.body != null) {
                int inc = 1 + this.body.length() / chunks;
                ByteArrayBuffer buf = new ByteArrayBuffer(this.body);
                View view = new View((Buffer)buf);
                for (int i = 1; i < chunks; ++i) {
                    view.setPutIndex(i * inc);
                    view.setGetIndex((i - 1) * inc);
                    hb.addContent((Buffer)view, false);
                    if (hb.isBufferFull() && hb.isState(0)) {
                        hb.completeHeader(fields, false);
                    }
                    if (i % 2 != 0) continue;
                    if (hb.isState(0)) {
                        if (version < 11) {
                            fields.addLongField("Content-Length", (long)this.body.length());
                        }
                        hb.completeHeader(fields, false);
                    }
                    hb.flushBuffer();
                }
                view.setPutIndex(buf.putIndex());
                view.setGetIndex((chunks - 1) * inc);
                hb.addContent((Buffer)view, true);
                if (hb.isState(0)) {
                    hb.completeHeader(fields, true);
                }
            } else {
                hb.completeHeader(fields, true);
            }
            hb.complete();
            while (!hb.isComplete()) {
                hb.flushBuffer();
            }
        }

        public String toString() {
            return "[" + this.values[0] + "," + this.values[1] + "," + (this.body == null ? "none" : "_content") + "]";
        }
    }
}

