/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.IOException;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.ByteArrayEndPoint;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.SimpleBuffers;
import org.eclipse.jetty.io.View;
import org.junit.Assert;
import org.junit.Test;

public class HttpGeneratorTest {
    public static final String CONTENT = "The quick brown fox jumped over the lazy dog.\nNow is the time for all good men to come to the aid of the party\nThe moon is blue to a fish in love.\n";
    public static final String[] connect = new String[]{null, "keep-alive", "close", "TE, close"};
    private static final String[] headers = new String[]{"Content-Type", "Content-Length", "Connection", "Transfer-Encoding", "Other"};
    private final TR[] tr = new TR[]{new TR(200, null, null, null, false), new TR(200, null, null, "The quick brown fox jumped over the lazy dog.\nNow is the time for all good men to come to the aid of the party\nThe moon is blue to a fish in love.\n", false), new TR(200, null, "" + "The quick brown fox jumped over the lazy dog.\nNow is the time for all good men to come to the aid of the party\nThe moon is blue to a fish in love.\n".length(), null, true), new TR(200, null, "" + "The quick brown fox jumped over the lazy dog.\nNow is the time for all good men to come to the aid of the party\nThe moon is blue to a fish in love.\n".length(), "The quick brown fox jumped over the lazy dog.\nNow is the time for all good men to come to the aid of the party\nThe moon is blue to a fish in love.\n", false), new TR(200, "text/html", null, null, true), new TR(200, "text/html", null, "The quick brown fox jumped over the lazy dog.\nNow is the time for all good men to come to the aid of the party\nThe moon is blue to a fish in love.\n", false), new TR(200, "text/html", "" + "The quick brown fox jumped over the lazy dog.\nNow is the time for all good men to come to the aid of the party\nThe moon is blue to a fish in love.\n".length(), null, true), new TR(200, "text/html", "" + "The quick brown fox jumped over the lazy dog.\nNow is the time for all good men to come to the aid of the party\nThe moon is blue to a fish in love.\n".length(), "The quick brown fox jumped over the lazy dog.\nNow is the time for all good men to come to the aid of the party\nThe moon is blue to a fish in love.\n", false)};
    private String content;
    private String f0;
    private String f1;
    private String f2;
    private String[] hdr;
    private String[] val;
    private int h;

    @Test
    public void testRequest() throws Exception {
        ByteArrayBuffer bb = new ByteArrayBuffer(8096);
        ByteArrayBuffer sb = new ByteArrayBuffer(1500);
        HttpFields fields = new HttpFields();
        ByteArrayEndPoint endp = new ByteArrayEndPoint(new byte[0], 4096);
        HttpGenerator hg = new HttpGenerator((Buffers)new SimpleBuffers((Buffer)sb, (Buffer)bb), (EndPoint)endp);
        fields.add("Host", "something");
        fields.add("User-Agent", "test");
        hg.setRequest("GET", "/index.html");
        hg.setVersion(11);
        hg.completeHeader(fields, true);
        hg.complete();
        Assert.assertTrue((endp.getOut().toString().indexOf("GET /index.html HTTP/1.1") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((endp.getOut().toString().indexOf("Content-Length") == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testHTTP() throws Exception {
        ByteArrayBuffer bb = new ByteArrayBuffer(8096);
        ByteArrayBuffer sb = new ByteArrayBuffer(1500);
        HttpFields fields = new HttpFields();
        ByteArrayEndPoint endp = new ByteArrayEndPoint(new byte[0], 4096);
        HttpGenerator hb = new HttpGenerator((Buffers)new SimpleBuffers((Buffer)sb, (Buffer)bb), (EndPoint)endp);
        Handler handler = new Handler();
        HttpParser parser = null;
        for (int v = 9; v <= 11; ++v) {
            for (int r = 0; r < this.tr.length; ++r) {
                for (int chunks = 1; chunks <= 6; ++chunks) {
                    for (int c = 0; c < (v == 11 ? connect.length : connect.length - 1); ++c) {
                        String t = "v=" + v + ",r=" + r + ",chunks=" + chunks + ",connect=" + c + ",tr=" + this.tr[r];
                        hb.reset(true);
                        endp.reset();
                        fields.clear();
                        this.tr[r].build(v, hb, "OK\r\nTest", HttpGeneratorTest.connect[c], null, chunks, fields);
                        String response = endp.getOut().toString();
                        if (v == 9) {
                            Assert.assertFalse((String)t, (boolean)hb.isPersistent());
                            if (this.tr[r]._body == null) continue;
                            Assert.assertEquals((String)t, (Object)this.tr[r]._body, (Object)response);
                            continue;
                        }
                        parser = new HttpParser((Buffer)new ByteArrayBuffer(response.getBytes()), (HttpParser.EventHandler)handler);
                        parser.setHeadResponse(this.tr[r]._head);
                        try {
                            parser.parse();
                        }
                        catch (IOException e) {
                            if (this.tr[r]._body == null) continue;
                            throw new Exception(t, e);
                        }
                        if (this.tr[r]._body != null) {
                            Assert.assertEquals((String)t, (Object)this.tr[r]._body, (Object)this.content);
                        }
                        if (v == 10) {
                            Assert.assertTrue((String)t, (hb.isPersistent() || this.tr[r]._contentLength == null || c == 2 || c == 0 ? 1 : 0) != 0);
                        } else {
                            Assert.assertTrue((String)t, (hb.isPersistent() || c == 2 || c == 3 ? 1 : 0) != 0);
                        }
                        if (v > 9) {
                            Assert.assertEquals((Object)"OK  Test", (Object)this.f2);
                        }
                        if (this.content == null) {
                            Assert.assertTrue((String)t, (this.tr[r]._body == null ? 1 : 0) != 0);
                            continue;
                        }
                        Assert.assertTrue((String)t, (this.tr[r]._contentLength == null || this.content.length() == Integer.parseInt(this.tr[r]._contentLength) ? 1 : 0) != 0);
                    }
                }
            }
        }
    }

    static /* synthetic */ String[] access$702(HttpGeneratorTest x0, String[] x1) {
        x0.hdr = x1;
        return x1;
    }

    static /* synthetic */ String[] access$802(HttpGeneratorTest x0, String[] x1) {
        x0.val = x1;
        return x1;
    }

    private class Handler
    extends HttpParser.EventHandler {
        private int index = 0;

        private Handler() {
        }

        public void content(Buffer ref) {
            if (this.index == 0) {
                HttpGeneratorTest.this.content = "";
            }
            HttpGeneratorTest.this.content = HttpGeneratorTest.this.content.substring(0, this.index) + ref;
            this.index += ref.length();
        }

        public void startRequest(Buffer tok0, Buffer tok1, Buffer tok2) {
            HttpGeneratorTest.this.h = -1;
            HttpGeneratorTest.access$702(HttpGeneratorTest.this, new String[9]);
            HttpGeneratorTest.access$802(HttpGeneratorTest.this, new String[9]);
            HttpGeneratorTest.this.f0 = tok0.toString();
            HttpGeneratorTest.this.f1 = tok1.toString();
            if (tok2 != null) {
                HttpGeneratorTest.this.f2 = tok2.toString();
            } else {
                HttpGeneratorTest.this.f2 = null;
            }
            this.index = 0;
        }

        public void startResponse(Buffer version, int status, Buffer reason) {
            HttpGeneratorTest.this.h = -1;
            HttpGeneratorTest.access$702(HttpGeneratorTest.this, new String[9]);
            HttpGeneratorTest.access$802(HttpGeneratorTest.this, new String[9]);
            HttpGeneratorTest.this.f0 = version.toString();
            HttpGeneratorTest.this.f1 = "" + status;
            if (reason != null) {
                HttpGeneratorTest.this.f2 = reason.toString();
            } else {
                HttpGeneratorTest.this.f2 = null;
            }
            this.index = 0;
        }

        public void parsedHeader(Buffer name, Buffer value) {
            ((HttpGeneratorTest)HttpGeneratorTest.this).hdr[++((HttpGeneratorTest)HttpGeneratorTest.this).h] = name.toString();
            ((HttpGeneratorTest)HttpGeneratorTest.this).val[((HttpGeneratorTest)HttpGeneratorTest.this).h] = value.toString();
        }

        public void headerComplete() {
            HttpGeneratorTest.this.content = null;
        }

        public void messageComplete(long contentLength) {
        }
    }

    private class TR {
        private int _code;
        private String _body;
        private boolean _head;
        String _contentType;
        String _contentLength;
        String _connection;
        String _te;
        String _other;

        private TR(int code, String contentType, String contentLength, String content, boolean head) {
            this._code = code;
            this._contentType = contentType;
            this._contentLength = contentLength;
            this._other = "value";
            this._body = content;
            this._head = head;
        }

        private void build(int version, HttpGenerator hb, String reason, String connection, String te, int chunks, HttpFields fields) throws Exception {
            this._connection = connection;
            this._te = te;
            hb.setVersion(version);
            hb.setResponse(this._code, reason);
            hb.setHead(this._head);
            if (this._contentType != null) {
                fields.put((Buffer)new ByteArrayBuffer("Content-Type"), (Buffer)new ByteArrayBuffer(this._contentType));
            }
            if (this._contentLength != null) {
                fields.put((Buffer)new ByteArrayBuffer("Content-Length"), (Buffer)new ByteArrayBuffer(this._contentLength));
            }
            if (this._connection != null) {
                fields.put((Buffer)new ByteArrayBuffer("Connection"), (Buffer)new ByteArrayBuffer(this._connection));
            }
            if (this._te != null) {
                fields.put((Buffer)new ByteArrayBuffer("Transfer-Encoding"), (Buffer)new ByteArrayBuffer(this._te));
            }
            if (this._other != null) {
                fields.put((Buffer)new ByteArrayBuffer("Other"), (Buffer)new ByteArrayBuffer(this._other));
            }
            if (this._body != null) {
                int inc = 1 + this._body.length() / chunks;
                ByteArrayBuffer buf = new ByteArrayBuffer(this._body);
                View view = new View((Buffer)buf);
                for (int i = 1; i < chunks; ++i) {
                    view.setPutIndex(i * inc);
                    view.setGetIndex((i - 1) * inc);
                    hb.addContent((Buffer)view, false);
                    if (hb.isBufferFull() && hb.isState(0)) {
                        hb.completeHeader(fields, false);
                    }
                    if (i % 2 != 0) continue;
                    if (hb.isState(0)) {
                        hb.completeHeader(fields, false);
                    }
                    hb.flushBuffer();
                }
                view.setPutIndex(buf.putIndex());
                view.setGetIndex((chunks - 1) * inc);
                hb.addContent((Buffer)view, true);
                if (hb.isState(0)) {
                    hb.completeHeader(fields, true);
                }
            } else {
                hb.completeHeader(fields, true);
            }
            hb.complete();
            while (!hb.isComplete()) {
                hb.flushBuffer();
            }
        }

        public String toString() {
            return "[" + this._code + "," + this._contentType + "," + this._contentLength + "," + (this._body == null ? "null" : "content") + "]";
        }
    }
}

