/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.UnsupportedEncodingException;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.SimpleBuffers;
import org.eclipse.jetty.io.bio.StringEndPoint;
import org.junit.Assert;
import org.junit.Test;

public class HttpParserTest {
    private String _content;
    private String f0;
    private String f1;
    private String f2;
    private String[] hdr;
    private String[] val;
    private int h;
    private boolean headerCompleted;
    private boolean messageCompleted;

    @Test
    public void testLineParse0() throws Exception {
        StringEndPoint io = new StringEndPoint();
        io.setInput("POST /foo HTTP/1.0\r\n\r\n");
        ByteArrayBuffer buffer = new ByteArrayBuffer(4096);
        SimpleBuffers buffers = new SimpleBuffers((Buffer)buffer, null);
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((Buffers)buffers, (EndPoint)io, (HttpParser.EventHandler)handler);
        parser.parse();
        Assert.assertEquals((Object)"POST", (Object)this.f0);
        Assert.assertEquals((Object)"/foo", (Object)this.f1);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)this.f2);
        Assert.assertEquals((long)-1L, (long)this.h);
    }

    @Test
    public void testLineParse1() throws Exception {
        StringEndPoint io = new StringEndPoint();
        io.setInput("GET /999\r\n");
        ByteArrayBuffer buffer = new ByteArrayBuffer(4096);
        SimpleBuffers buffers = new SimpleBuffers((Buffer)buffer, null);
        this.f2 = null;
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((Buffers)buffers, (EndPoint)io, (HttpParser.EventHandler)handler);
        parser.parse();
        Assert.assertEquals((Object)"GET", (Object)this.f0);
        Assert.assertEquals((Object)"/999", (Object)this.f1);
        Assert.assertEquals(null, (Object)this.f2);
        Assert.assertEquals((long)-1L, (long)this.h);
    }

    @Test
    public void testLineParse2() throws Exception {
        StringEndPoint io = new StringEndPoint();
        io.setInput("POST /222  \r\n");
        ByteArrayBuffer buffer = new ByteArrayBuffer(4096);
        SimpleBuffers buffers = new SimpleBuffers((Buffer)buffer, null);
        this.f2 = null;
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((Buffers)buffers, (EndPoint)io, (HttpParser.EventHandler)handler);
        parser.parse();
        Assert.assertEquals((Object)"POST", (Object)this.f0);
        Assert.assertEquals((Object)"/222", (Object)this.f1);
        Assert.assertEquals(null, (Object)this.f2);
        Assert.assertEquals((long)-1L, (long)this.h);
    }

    @Test
    public void testLineParse3() throws Exception {
        StringEndPoint io = new StringEndPoint();
        io.setInput("POST /fo\u0690 HTTP/1.0\r\n\r\n");
        ByteArrayBuffer buffer = new ByteArrayBuffer(4096);
        SimpleBuffers buffers = new SimpleBuffers((Buffer)buffer, null);
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((Buffers)buffers, (EndPoint)io, (HttpParser.EventHandler)handler);
        parser.parse();
        Assert.assertEquals((Object)"POST", (Object)this.f0);
        Assert.assertEquals((Object)"/fo\u0690", (Object)this.f1);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)this.f2);
        Assert.assertEquals((long)-1L, (long)this.h);
    }

    @Test
    public void testLineParse4() throws Exception {
        StringEndPoint io = new StringEndPoint();
        io.setInput("POST /foo?param=\u0690 HTTP/1.0\r\n\r\n");
        ByteArrayBuffer buffer = new ByteArrayBuffer(4096);
        SimpleBuffers buffers = new SimpleBuffers((Buffer)buffer, null);
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((Buffers)buffers, (EndPoint)io, (HttpParser.EventHandler)handler);
        parser.parse();
        Assert.assertEquals((Object)"POST", (Object)this.f0);
        Assert.assertEquals((Object)"/foo?param=\u0690", (Object)this.f1);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)this.f2);
        Assert.assertEquals((long)-1L, (long)this.h);
    }

    @Test
    public void testConnect() throws Exception {
        StringEndPoint io = new StringEndPoint();
        io.setInput("CONNECT 192.168.1.2:80 HTTP/1.1\r\n\r\n");
        ByteArrayBuffer buffer = new ByteArrayBuffer(4096);
        SimpleBuffers buffers = new SimpleBuffers((Buffer)buffer, null);
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((Buffers)buffers, (EndPoint)io, (HttpParser.EventHandler)handler);
        parser.parse();
        Assert.assertTrue((boolean)handler.request);
        Assert.assertEquals((Object)"CONNECT", (Object)this.f0);
        Assert.assertEquals((Object)"192.168.1.2:80", (Object)this.f1);
        Assert.assertEquals((Object)"HTTP/1.1", (Object)this.f2);
        Assert.assertEquals((long)-1L, (long)this.h);
    }

    @Test
    public void testHeaderParse() throws Exception {
        StringEndPoint io = new StringEndPoint();
        io.setInput("GET / HTTP/1.0\r\nHost: localhost\r\nHeader1: value1\r\nHeader2  :   value 2a  \r\n                    value 2b  \r\nHeader3: \r\nHeader4 \r\n  value4\r\nServer5: notServer\r\n\r\n");
        ByteArrayBuffer buffer = new ByteArrayBuffer(4096);
        SimpleBuffers buffers = new SimpleBuffers((Buffer)buffer, null);
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((Buffers)buffers, (EndPoint)io, (HttpParser.EventHandler)handler);
        parser.parse();
        Assert.assertEquals((Object)"GET", (Object)this.f0);
        Assert.assertEquals((Object)"/", (Object)this.f1);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)this.f2);
        Assert.assertEquals((Object)"Host", (Object)this.hdr[0]);
        Assert.assertEquals((Object)"localhost", (Object)this.val[0]);
        Assert.assertEquals((Object)"Header1", (Object)this.hdr[1]);
        Assert.assertEquals((Object)"value1", (Object)this.val[1]);
        Assert.assertEquals((Object)"Header2", (Object)this.hdr[2]);
        Assert.assertEquals((Object)"value 2a value 2b", (Object)this.val[2]);
        Assert.assertEquals((Object)"Header3", (Object)this.hdr[3]);
        Assert.assertEquals((Object)"", (Object)this.val[3]);
        Assert.assertEquals((Object)"Header4", (Object)this.hdr[4]);
        Assert.assertEquals((Object)"value4", (Object)this.val[4]);
        Assert.assertEquals((Object)"Server5", (Object)this.hdr[5]);
        Assert.assertEquals((Object)"notServer", (Object)this.val[5]);
        Assert.assertEquals((long)5L, (long)this.h);
    }

    @Test
    public void testChunkParse() throws Exception {
        StringEndPoint io = new StringEndPoint();
        io.setInput("GET /chunk HTTP/1.0\r\nHeader1: value1\r\nTransfer-Encoding: chunked\r\n\r\na;\r\n0123456789\r\n1a\r\nABCDEFGHIJKLMNOPQRSTUVWXYZ\r\n0\r\n");
        ByteArrayBuffer buffer = new ByteArrayBuffer(4096);
        ByteArrayBuffer content = new ByteArrayBuffer(8192);
        SimpleBuffers buffers = new SimpleBuffers((Buffer)buffer, (Buffer)content);
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((Buffers)buffers, (EndPoint)io, (HttpParser.EventHandler)handler);
        parser.parse();
        Assert.assertEquals((Object)"GET", (Object)this.f0);
        Assert.assertEquals((Object)"/chunk", (Object)this.f1);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)this.f2);
        Assert.assertEquals((long)1L, (long)this.h);
        Assert.assertEquals((Object)"Header1", (Object)this.hdr[0]);
        Assert.assertEquals((Object)"value1", (Object)this.val[0]);
        Assert.assertEquals((Object)"0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ", (Object)this._content);
    }

    @Test
    public void testMultiParse() throws Exception {
        StringEndPoint io = new StringEndPoint();
        io.setInput("GET /mp HTTP/1.0\r\nHeader1: value1\r\nTransfer-Encoding: chunked\r\n\r\na;\r\n0123456789\r\n1a\r\nABCDEFGHIJKLMNOPQRSTUVWXYZ\r\n0\r\nPOST /foo HTTP/1.0\r\nHeader2: value2\r\nContent-Length: 0\r\n\r\nPUT /doodle HTTP/1.0\r\nHeader3: value3\r\nContent-Length: 10\r\n\r\n0123456789\r\n");
        ByteArrayBuffer buffer = new ByteArrayBuffer(4096);
        ByteArrayBuffer content = new ByteArrayBuffer(8192);
        SimpleBuffers buffers = new SimpleBuffers((Buffer)buffer, (Buffer)content);
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((Buffers)buffers, (EndPoint)io, (HttpParser.EventHandler)handler);
        parser.parse();
        Assert.assertEquals((Object)"GET", (Object)this.f0);
        Assert.assertEquals((Object)"/mp", (Object)this.f1);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)this.f2);
        Assert.assertEquals((long)1L, (long)this.h);
        Assert.assertEquals((Object)"Header1", (Object)this.hdr[0]);
        Assert.assertEquals((Object)"value1", (Object)this.val[0]);
        Assert.assertEquals((Object)"0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ", (Object)this._content);
        parser.parse();
        Assert.assertEquals((Object)"POST", (Object)this.f0);
        Assert.assertEquals((Object)"/foo", (Object)this.f1);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)this.f2);
        Assert.assertEquals((long)1L, (long)this.h);
        Assert.assertEquals((Object)"Header2", (Object)this.hdr[0]);
        Assert.assertEquals((Object)"value2", (Object)this.val[0]);
        Assert.assertEquals(null, (Object)this._content);
        parser.parse();
        Assert.assertEquals((Object)"PUT", (Object)this.f0);
        Assert.assertEquals((Object)"/doodle", (Object)this.f1);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)this.f2);
        Assert.assertEquals((long)1L, (long)this.h);
        Assert.assertEquals((Object)"Header3", (Object)this.hdr[0]);
        Assert.assertEquals((Object)"value3", (Object)this.val[0]);
        Assert.assertEquals((Object)"0123456789", (Object)this._content);
    }

    @Test
    public void testStreamParse() throws Exception {
        StringEndPoint io = new StringEndPoint();
        String http = "GET / HTTP/1.0\r\nHeader1: value1\r\nTransfer-Encoding: chunked\r\n\r\na;\r\n0123456789\r\n1a\r\nABCDEFGHIJKLMNOPQRSTUVWXYZ\r\n0\r\nPOST /foo HTTP/1.0\r\nHeader2: value2\r\nContent-Length: 0\r\n\r\nPUT /doodle HTTP/1.0\r\nHeader3: value3\r\nContent-Length: 10\r\n\r\n0123456789\r\n";
        int[] tests = new int[]{1024, http.length() + 3, http.length() + 2, http.length() + 1, http.length() + 0, http.length() - 1, http.length() - 2, http.length() / 2, http.length() / 3, 64, 32};
        for (int t = 0; t < tests.length; ++t) {
            String tst = "t" + tests[t];
            try {
                ByteArrayBuffer buffer = new ByteArrayBuffer(tests[t]);
                ByteArrayBuffer content = new ByteArrayBuffer(8192);
                SimpleBuffers buffers = new SimpleBuffers((Buffer)buffer, (Buffer)content);
                Handler handler = new Handler();
                HttpParser parser = new HttpParser((Buffers)buffers, (EndPoint)io, (HttpParser.EventHandler)handler);
                io.setInput(http);
                parser.parse();
                Assert.assertEquals((String)tst, (Object)"GET", (Object)this.f0);
                Assert.assertEquals((String)tst, (Object)"/", (Object)this.f1);
                Assert.assertEquals((String)tst, (Object)"HTTP/1.0", (Object)this.f2);
                Assert.assertEquals((String)tst, (long)1L, (long)this.h);
                Assert.assertEquals((String)tst, (Object)"Header1", (Object)this.hdr[0]);
                Assert.assertEquals((String)tst, (Object)"value1", (Object)this.val[0]);
                Assert.assertEquals((String)tst, (Object)"0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ", (Object)this._content);
                parser.parse();
                Assert.assertEquals((String)tst, (Object)"POST", (Object)this.f0);
                Assert.assertEquals((String)tst, (Object)"/foo", (Object)this.f1);
                Assert.assertEquals((String)tst, (Object)"HTTP/1.0", (Object)this.f2);
                Assert.assertEquals((String)tst, (long)1L, (long)this.h);
                Assert.assertEquals((String)tst, (Object)"Header2", (Object)this.hdr[0]);
                Assert.assertEquals((String)tst, (Object)"value2", (Object)this.val[0]);
                Assert.assertEquals((String)tst, null, (Object)this._content);
                parser.parse();
                Assert.assertEquals((String)tst, (Object)"PUT", (Object)this.f0);
                Assert.assertEquals((String)tst, (Object)"/doodle", (Object)this.f1);
                Assert.assertEquals((String)tst, (Object)"HTTP/1.0", (Object)this.f2);
                Assert.assertEquals((String)tst, (long)1L, (long)this.h);
                Assert.assertEquals((String)tst, (Object)"Header3", (Object)this.hdr[0]);
                Assert.assertEquals((String)tst, (Object)"value3", (Object)this.val[0]);
                Assert.assertEquals((String)tst, (Object)"0123456789", (Object)this._content);
                continue;
            }
            catch (Exception e) {
                if (t + 1 < tests.length) {
                    throw e;
                }
                Assert.assertTrue((e.toString().indexOf("FULL") >= 0 ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testResponseParse0() throws Exception {
        StringEndPoint io = new StringEndPoint();
        io.setInput("HTTP/1.1 200 Correct\r\nContent-Length: 10\r\nContent-Type: text/plain\r\n\r\n0123456789\r\n");
        ByteArrayBuffer buffer = new ByteArrayBuffer(4096);
        SimpleBuffers buffers = new SimpleBuffers((Buffer)buffer, null);
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((Buffers)buffers, (EndPoint)io, (HttpParser.EventHandler)handler);
        parser.parse();
        Assert.assertEquals((Object)"HTTP/1.1", (Object)this.f0);
        Assert.assertEquals((Object)"200", (Object)this.f1);
        Assert.assertEquals((Object)"Correct", (Object)this.f2);
        Assert.assertEquals((long)this._content.length(), (long)10L);
        Assert.assertTrue((boolean)this.headerCompleted);
        Assert.assertTrue((boolean)this.messageCompleted);
    }

    @Test
    public void testResponseParse1() throws Exception {
        StringEndPoint io = new StringEndPoint();
        io.setInput("HTTP/1.1 304 Not-Modified\r\nConnection: close\r\n\r\n");
        ByteArrayBuffer buffer = new ByteArrayBuffer(4096);
        SimpleBuffers buffers = new SimpleBuffers((Buffer)buffer, null);
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((Buffers)buffers, (EndPoint)io, (HttpParser.EventHandler)handler);
        parser.parse();
        Assert.assertEquals((Object)"HTTP/1.1", (Object)this.f0);
        Assert.assertEquals((Object)"304", (Object)this.f1);
        Assert.assertEquals((Object)"Not-Modified", (Object)this.f2);
        Assert.assertTrue((boolean)this.headerCompleted);
        Assert.assertTrue((boolean)this.messageCompleted);
    }

    @Test
    public void testResponseParse2() throws Exception {
        StringEndPoint io = new StringEndPoint();
        io.setInput("HTTP/1.1 204 No-Content\r\nConnection: close\r\n\r\nHTTP/1.1 200 Correct\r\nContent-Length: 10\r\nContent-Type: text/plain\r\n\r\n0123456789\r\n");
        ByteArrayBuffer buffer = new ByteArrayBuffer(4096);
        SimpleBuffers buffers = new SimpleBuffers((Buffer)buffer, null);
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((Buffers)buffers, (EndPoint)io, (HttpParser.EventHandler)handler);
        parser.parse();
        Assert.assertEquals((Object)"HTTP/1.1", (Object)this.f0);
        Assert.assertEquals((Object)"204", (Object)this.f1);
        Assert.assertEquals((Object)"No-Content", (Object)this.f2);
        Assert.assertTrue((boolean)this.headerCompleted);
        Assert.assertTrue((boolean)this.messageCompleted);
        parser.parse();
        Assert.assertEquals((Object)"HTTP/1.1", (Object)this.f0);
        Assert.assertEquals((Object)"200", (Object)this.f1);
        Assert.assertEquals((Object)"Correct", (Object)this.f2);
        Assert.assertEquals((long)this._content.length(), (long)10L);
        Assert.assertTrue((boolean)this.headerCompleted);
        Assert.assertTrue((boolean)this.messageCompleted);
    }

    @Test
    public void testResponseParse3() throws Exception {
        StringEndPoint io = new StringEndPoint();
        io.setInput("HTTP/1.1 200\r\nContent-Length: 10\r\nContent-Type: text/plain\r\n\r\n0123456789\r\n");
        ByteArrayBuffer buffer = new ByteArrayBuffer(4096);
        SimpleBuffers buffers = new SimpleBuffers((Buffer)buffer, null);
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((Buffers)buffers, (EndPoint)io, (HttpParser.EventHandler)handler);
        parser.parse();
        Assert.assertEquals((Object)"HTTP/1.1", (Object)this.f0);
        Assert.assertEquals((Object)"200", (Object)this.f1);
        Assert.assertEquals(null, (Object)this.f2);
        Assert.assertEquals((long)this._content.length(), (long)10L);
        Assert.assertTrue((boolean)this.headerCompleted);
        Assert.assertTrue((boolean)this.messageCompleted);
    }

    @Test
    public void testResponseParse4() throws Exception {
        StringEndPoint io = new StringEndPoint();
        io.setInput("HTTP/1.1 200 \r\nContent-Length: 10\r\nContent-Type: text/plain\r\n\r\n0123456789\r\n");
        ByteArrayBuffer buffer = new ByteArrayBuffer(4096);
        SimpleBuffers buffers = new SimpleBuffers((Buffer)buffer, null);
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((Buffers)buffers, (EndPoint)io, (HttpParser.EventHandler)handler);
        parser.parse();
        Assert.assertEquals((Object)"HTTP/1.1", (Object)this.f0);
        Assert.assertEquals((Object)"200", (Object)this.f1);
        Assert.assertEquals(null, (Object)this.f2);
        Assert.assertEquals((long)this._content.length(), (long)10L);
        Assert.assertTrue((boolean)this.headerCompleted);
        Assert.assertTrue((boolean)this.messageCompleted);
    }

    @Test
    public void testResponse304WithContentLength() throws Exception {
        StringEndPoint io = new StringEndPoint();
        io.setInput("HTTP/1.1 304 found\r\nContent-Length: 10\r\n\r\n");
        ByteArrayBuffer buffer = new ByteArrayBuffer(4096);
        SimpleBuffers buffers = new SimpleBuffers((Buffer)buffer, null);
        Handler handler = new Handler();
        HttpParser parser = new HttpParser((Buffers)buffers, (EndPoint)io, (HttpParser.EventHandler)handler);
        parser.parse();
        Assert.assertEquals((Object)"HTTP/1.1", (Object)this.f0);
        Assert.assertEquals((Object)"304", (Object)this.f1);
        Assert.assertEquals((Object)"found", (Object)this.f2);
        Assert.assertEquals(null, (Object)this._content);
        Assert.assertTrue((boolean)this.headerCompleted);
        Assert.assertTrue((boolean)this.messageCompleted);
    }

    static /* synthetic */ String[] access$402(HttpParserTest x0, String[] x1) {
        x0.hdr = x1;
        return x1;
    }

    static /* synthetic */ String[] access$502(HttpParserTest x0, String[] x1) {
        x0.val = x1;
        return x1;
    }

    private class Handler
    extends HttpParser.EventHandler {
        private HttpFields fields;
        private boolean request;

        private Handler() {
        }

        public void content(Buffer ref) {
            if (HttpParserTest.this._content == null) {
                HttpParserTest.this._content = "";
            }
            HttpParserTest.this._content = HttpParserTest.this._content + ref;
        }

        public void startRequest(Buffer tok0, Buffer tok1, Buffer tok2) {
            try {
                this.request = true;
                HttpParserTest.this.h = -1;
                HttpParserTest.access$402(HttpParserTest.this, new String[9]);
                HttpParserTest.access$502(HttpParserTest.this, new String[9]);
                HttpParserTest.this.f0 = tok0.toString();
                HttpParserTest.this.f1 = new String(tok1.array(), tok1.getIndex(), tok1.length(), "UTF-8");
                if (tok2 != null) {
                    HttpParserTest.this.f2 = tok2.toString();
                } else {
                    HttpParserTest.this.f2 = null;
                }
                this.fields = new HttpFields();
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            HttpParserTest.this.messageCompleted = false;
            HttpParserTest.this.headerCompleted = false;
        }

        public void parsedHeader(Buffer name, Buffer value) {
            ((HttpParserTest)HttpParserTest.this).hdr[++((HttpParserTest)HttpParserTest.this).h] = name.toString("ISO-8859-1");
            ((HttpParserTest)HttpParserTest.this).val[((HttpParserTest)HttpParserTest.this).h] = value.toString("ISO-8859-1");
        }

        public void headerComplete() {
            HttpParserTest.this._content = null;
            String s0 = this.fields.toString();
            String s1 = this.fields.toString();
            if (!s0.equals(s1)) {
                throw new IllegalStateException();
            }
            HttpParserTest.this.headerCompleted = true;
        }

        public void messageComplete(long contentLength) {
            HttpParserTest.this.messageCompleted = true;
        }

        public void startResponse(Buffer version, int status, Buffer reason) {
            this.request = false;
            HttpParserTest.this.f0 = version.toString();
            HttpParserTest.this.f1 = Integer.toString(status);
            HttpParserTest.this.f2 = reason == null ? null : reason.toString();
            this.fields = new HttpFields();
            HttpParserTest.access$402(HttpParserTest.this, new String[9]);
            HttpParserTest.access$502(HttpParserTest.this, new String[9]);
            HttpParserTest.this.messageCompleted = false;
            HttpParserTest.this.headerCompleted = false;
        }
    }
}

