/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import junit.framework.TestCase;
import org.eclipse.jetty.http.PathMap;
import org.junit.Test;

public class PathMapTest
extends TestCase {
    @Test
    public void testPathMap() throws Exception {
        String[][] tests;
        PathMap p = new PathMap();
        p.put((Object)"/abs/path", (Object)"1");
        p.put((Object)"/abs/path/longer", (Object)"2");
        p.put((Object)"/animal/bird/*", (Object)"3");
        p.put((Object)"/animal/fish/*", (Object)"4");
        p.put((Object)"/animal/*", (Object)"5");
        p.put((Object)"*.tar.gz", (Object)"6");
        p.put((Object)"*.gz", (Object)"7");
        p.put((Object)"/", (Object)"8");
        p.put((Object)"/XXX:/YYY", (Object)"9");
        for (String[] test : tests = new String[][]{{"/abs/path", "1"}, {"/abs/path/xxx", "8"}, {"/abs/pith", "8"}, {"/abs/path/longer", "2"}, {"/abs/path/", "8"}, {"/abs/path/xxx", "8"}, {"/animal/bird/eagle/bald", "3"}, {"/animal/fish/shark/grey", "4"}, {"/animal/insect/bug", "5"}, {"/animal", "5"}, {"/animal/", "5"}, {"/animal/x", "5"}, {"/animal/*", "5"}, {"/suffix/path.tar.gz", "6"}, {"/suffix/path.gz", "7"}, {"/animal/path.gz", "5"}, {"/Other/path", "8"}}) {
            PathMapTest.assertEquals((String)test[0], (Object)test[1], (Object)p.getMatch(test[0]).getValue());
        }
        PathMapTest.assertEquals((String)"Get absolute path", (Object)"1", (Object)p.get((Object)"/abs/path"));
        PathMapTest.assertEquals((String)"Match absolute path", (Object)"/abs/path", (Object)p.getMatch("/abs/path").getKey());
        PathMapTest.assertEquals((String)"all matches", (String)"[/animal/bird/*=3, /animal/*=5, *.tar.gz=6, *.gz=7, /=8]", (String)p.getMatches("/animal/bird/path.tar.gz").toString());
        PathMapTest.assertEquals((String)"Dir matches", (String)"[/animal/fish/*=4, /animal/*=5, /=8]", (String)p.getMatches("/animal/fish/").toString());
        PathMapTest.assertEquals((String)"Dir matches", (String)"[/animal/fish/*=4, /animal/*=5, /=8]", (String)p.getMatches("/animal/fish").toString());
        PathMapTest.assertEquals((String)"Dir matches", (String)"[/=8]", (String)p.getMatches("/").toString());
        PathMapTest.assertEquals((String)"Dir matches", (String)"[/=8]", (String)p.getMatches("").toString());
        PathMapTest.assertEquals((String)"pathMatch exact", (String)"/Foo/bar", (String)PathMap.pathMatch((String)"/Foo/bar", (String)"/Foo/bar"));
        PathMapTest.assertEquals((String)"pathMatch prefix", (String)"/Foo", (String)PathMap.pathMatch((String)"/Foo/*", (String)"/Foo/bar"));
        PathMapTest.assertEquals((String)"pathMatch prefix", (String)"/Foo", (String)PathMap.pathMatch((String)"/Foo/*", (String)"/Foo/"));
        PathMapTest.assertEquals((String)"pathMatch prefix", (String)"/Foo", (String)PathMap.pathMatch((String)"/Foo/*", (String)"/Foo"));
        PathMapTest.assertEquals((String)"pathMatch suffix", (String)"/Foo/bar.ext", (String)PathMap.pathMatch((String)"*.ext", (String)"/Foo/bar.ext"));
        PathMapTest.assertEquals((String)"pathMatch default", (String)"/Foo/bar.ext", (String)PathMap.pathMatch((String)"/", (String)"/Foo/bar.ext"));
        PathMapTest.assertEquals((String)"pathInfo exact", null, (String)PathMap.pathInfo((String)"/Foo/bar", (String)"/Foo/bar"));
        PathMapTest.assertEquals((String)"pathInfo prefix", (String)"/bar", (String)PathMap.pathInfo((String)"/Foo/*", (String)"/Foo/bar"));
        PathMapTest.assertEquals((String)"pathInfo prefix", (String)"/*", (String)PathMap.pathInfo((String)"/Foo/*", (String)"/Foo/*"));
        PathMapTest.assertEquals((String)"pathInfo prefix", (String)"/", (String)PathMap.pathInfo((String)"/Foo/*", (String)"/Foo/"));
        PathMapTest.assertEquals((String)"pathInfo prefix", null, (String)PathMap.pathInfo((String)"/Foo/*", (String)"/Foo"));
        PathMapTest.assertEquals((String)"pathInfo suffix", null, (String)PathMap.pathInfo((String)"*.ext", (String)"/Foo/bar.ext"));
        PathMapTest.assertEquals((String)"pathInfo default", null, (String)PathMap.pathInfo((String)"/", (String)"/Foo/bar.ext"));
        PathMapTest.assertEquals((String)"multi paths", (Object)"9", (Object)p.getMatch("/XXX").getValue());
        PathMapTest.assertEquals((String)"multi paths", (Object)"9", (Object)p.getMatch("/YYY").getValue());
        p.put((Object)"/*", (Object)"0");
        PathMapTest.assertEquals((String)"Get absolute path", (Object)"1", (Object)p.get((Object)"/abs/path"));
        PathMapTest.assertEquals((String)"Match absolute path", (Object)"/abs/path", (Object)p.getMatch("/abs/path").getKey());
        PathMapTest.assertEquals((String)"Match absolute path", (Object)"1", (Object)p.getMatch("/abs/path").getValue());
        PathMapTest.assertEquals((String)"Mismatch absolute path", (Object)"0", (Object)p.getMatch("/abs/path/xxx").getValue());
        PathMapTest.assertEquals((String)"Mismatch absolute path", (Object)"0", (Object)p.getMatch("/abs/pith").getValue());
        PathMapTest.assertEquals((String)"Match longer absolute path", (Object)"2", (Object)p.getMatch("/abs/path/longer").getValue());
        PathMapTest.assertEquals((String)"Not exact absolute path", (Object)"0", (Object)p.getMatch("/abs/path/").getValue());
        PathMapTest.assertEquals((String)"Not exact absolute path", (Object)"0", (Object)p.getMatch("/abs/path/xxx").getValue());
        PathMapTest.assertEquals((String)"Match longest prefix", (Object)"3", (Object)p.getMatch("/animal/bird/eagle/bald").getValue());
        PathMapTest.assertEquals((String)"Match longest prefix", (Object)"4", (Object)p.getMatch("/animal/fish/shark/grey").getValue());
        PathMapTest.assertEquals((String)"Match longest prefix", (Object)"5", (Object)p.getMatch("/animal/insect/bug").getValue());
        PathMapTest.assertEquals((String)"mismatch exact prefix", (Object)"5", (Object)p.getMatch("/animal").getValue());
        PathMapTest.assertEquals((String)"mismatch exact prefix", (Object)"5", (Object)p.getMatch("/animal/").getValue());
        PathMapTest.assertEquals((String)"Match longest suffix", (Object)"0", (Object)p.getMatch("/suffix/path.tar.gz").getValue());
        PathMapTest.assertEquals((String)"Match longest suffix", (Object)"0", (Object)p.getMatch("/suffix/path.gz").getValue());
        PathMapTest.assertEquals((String)"prefix rather than suffix", (Object)"5", (Object)p.getMatch("/animal/path.gz").getValue());
        PathMapTest.assertEquals((String)"default", (Object)"0", (Object)p.getMatch("/Other/path").getValue());
        PathMapTest.assertEquals((String)"pathMatch /*", (String)"", (String)PathMap.pathMatch((String)"/*", (String)"/xxx/zzz"));
        PathMapTest.assertEquals((String)"pathInfo /*", (String)"/xxx/zzz", (String)PathMap.pathInfo((String)"/*", (String)"/xxx/zzz"));
        PathMapTest.assertTrue((String)"match /", (boolean)PathMap.match((String)"/", (String)"/anything"));
        PathMapTest.assertTrue((String)"match /*", (boolean)PathMap.match((String)"/*", (String)"/anything"));
        PathMapTest.assertTrue((String)"match /foo", (boolean)PathMap.match((String)"/foo", (String)"/foo"));
        PathMapTest.assertTrue((String)"!match /foo", (!PathMap.match((String)"/foo", (String)"/bar") ? 1 : 0) != 0);
        PathMapTest.assertTrue((String)"match /foo/*", (boolean)PathMap.match((String)"/foo/*", (String)"/foo"));
        PathMapTest.assertTrue((String)"match /foo/*", (boolean)PathMap.match((String)"/foo/*", (String)"/foo/"));
        PathMapTest.assertTrue((String)"match /foo/*", (boolean)PathMap.match((String)"/foo/*", (String)"/foo/anything"));
        PathMapTest.assertTrue((String)"!match /foo/*", (!PathMap.match((String)"/foo/*", (String)"/bar") ? 1 : 0) != 0);
        PathMapTest.assertTrue((String)"!match /foo/*", (!PathMap.match((String)"/foo/*", (String)"/bar/") ? 1 : 0) != 0);
        PathMapTest.assertTrue((String)"!match /foo/*", (!PathMap.match((String)"/foo/*", (String)"/bar/anything") ? 1 : 0) != 0);
        PathMapTest.assertTrue((String)"match *.foo", (boolean)PathMap.match((String)"*.foo", (String)"anything.foo"));
        PathMapTest.assertTrue((String)"!match *.foo", (!PathMap.match((String)"*.foo", (String)"anything.bar") ? 1 : 0) != 0);
    }

    @Test
    public void testPathMappingsOnlyMatchOnDirectoryNames() throws Exception {
        String spec = "/xyz/*";
        this.assertMatch(spec, "/xyz");
        this.assertMatch(spec, "/xyz/");
        this.assertMatch(spec, "/xyz/123");
        this.assertMatch(spec, "/xyz/123/");
        this.assertMatch(spec, "/xyz/123.txt");
        this.assertNotMatch(spec, "/xyz123");
        this.assertNotMatch(spec, "/xyz123;jessionid=99");
        this.assertNotMatch(spec, "/xyz123/");
        this.assertNotMatch(spec, "/xyz123/456");
        this.assertNotMatch(spec, "/xyz.123");
        this.assertNotMatch(spec, "/xyz;123");
        this.assertNotMatch(spec, "/xyz?123");
    }

    private void assertMatch(String spec, String path) {
        boolean match = PathMap.match((String)spec, (String)path);
        PathMapTest.assertTrue((String)("PathSpec '" + spec + "' should match path '" + path + "'"), (boolean)match);
    }

    private void assertNotMatch(String spec, String path) {
        boolean match = PathMap.match((String)spec, (String)path);
        PathMapTest.assertFalse((String)("PathSpec '" + spec + "' should not match path '" + path + "'"), (boolean)match);
    }
}

