/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.net.URI;
import org.eclipse.jetty.http.HttpURI;
import org.junit.Assert;
import org.junit.Test;

public class HttpURITest {
    public static final String __input = "http://example.com:8080/path/to/context?parameter=%22value%22#fragment";
    public static final String __scheme = "http";
    public static final String __host = "example.com";
    public static final int __port = 8080;
    public static final String __path = "/path/to/context";
    public static final String __query = "parameter=%22value%22";
    public static final String __fragment = "fragment";

    @Test
    public void testFromString() throws Exception {
        HttpURI uri = new HttpURI(__input);
        Assert.assertEquals((Object)__scheme, (Object)uri.getScheme());
        Assert.assertEquals((Object)__host, (Object)uri.getHost());
        Assert.assertEquals((long)8080L, (long)uri.getPort());
        Assert.assertEquals((Object)__path, (Object)uri.getPath());
        Assert.assertEquals((Object)__query, (Object)uri.getQuery());
        Assert.assertEquals((Object)__fragment, (Object)uri.getFragment());
    }

    @Test
    public void testFromURI() throws Exception {
        HttpURI uri = new HttpURI(new URI(__input));
        Assert.assertEquals((Object)__scheme, (Object)uri.getScheme());
        Assert.assertEquals((Object)__host, (Object)uri.getHost());
        Assert.assertEquals((long)8080L, (long)uri.getPort());
        Assert.assertEquals((Object)__path, (Object)uri.getPath());
        Assert.assertEquals((Object)__query, (Object)uri.getQuery());
        Assert.assertEquals((Object)__fragment, (Object)uri.getFragment());
    }
}

