/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.Buffer;
import org.junit.Assert;
import org.junit.Test;

public class MimeTypesTest {
    @Test
    public void testGetMimeByExtension_Gzip() {
        this.assertMimeTypeByExtension("application/gzip", "test.gz");
    }

    @Test
    public void testGetMimeByExtension_Png() {
        this.assertMimeTypeByExtension("image/png", "test.png");
        this.assertMimeTypeByExtension("image/png", "TEST.PNG");
        this.assertMimeTypeByExtension("image/png", "Test.Png");
    }

    @Test
    public void testGetMimeByExtension_Png_MultiDot() {
        this.assertMimeTypeByExtension("image/png", "org.eclipse.jetty.Logo.png");
    }

    @Test
    public void testGetMimeByExtension_Png_DeepPath() {
        this.assertMimeTypeByExtension("image/png", "/org/eclipse/jetty/Logo.png");
    }

    @Test
    public void testGetMimeByExtension_Text() {
        this.assertMimeTypeByExtension("text/plain", "test.txt");
        this.assertMimeTypeByExtension("text/plain", "TEST.TXT");
    }

    private void assertMimeTypeByExtension(String expectedMimeType, String filename) {
        MimeTypes mimetypes = new MimeTypes();
        Buffer contentType = mimetypes.getMimeByExtension(filename);
        String prefix = "MimeTypes.getMimeByExtension(" + filename + ")";
        Assert.assertNotNull((String)prefix, (Object)contentType);
        Assert.assertEquals((String)prefix, (Object)expectedMimeType, (Object)contentType.toString());
    }
}

