/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AsyncContextTest {
    private Server _server = new Server();
    private ServletContextHandler _contextHandler = new ServletContextHandler(0);
    private LocalConnector _connector = new LocalConnector();

    @Before
    public void setUp() throws Exception {
        this._connector.setMaxIdleTime(30000);
        this._server.setConnectors(new Connector[]{this._connector});
        this._contextHandler.setContextPath("/");
        this._contextHandler.addServlet(new ServletHolder((Servlet)new TestServlet()), "/servletPath");
        this._contextHandler.addServlet(new ServletHolder((Servlet)new TestServlet()), "/path with spaces/servletPath");
        this._contextHandler.addServlet(new ServletHolder((Servlet)new TestServlet2()), "/servletPath2");
        this._contextHandler.addServlet(new ServletHolder((Servlet)new ForwardingServlet()), "/forward");
        this._contextHandler.addServlet(new ServletHolder((Servlet)new AsyncDispatchingServlet()), "/dispatchingServlet");
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{this._contextHandler, new DefaultHandler()});
        this._server.setHandler((Handler)handlers);
        this._server.start();
    }

    @Test
    public void testSimpleAsyncContext() throws Exception {
        String request = "GET /servletPath HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
        String responseString = this._connector.getResponses(request);
        BufferedReader br = this.parseHeader(responseString);
        junit.framework.Assert.assertEquals((String)"servlet gets right path", (String)"doGet:getServletPath:/servletPath", (String)br.readLine());
        junit.framework.Assert.assertEquals((String)"async context gets right path in get", (String)"doGet:async:getServletPath:/servletPath", (String)br.readLine());
        junit.framework.Assert.assertEquals((String)"async context gets right path in async", (String)"async:run:attr:servletPath:/servletPath", (String)br.readLine());
    }

    @Test
    public void testDispatchAsyncContext() throws Exception {
        String request = "GET /servletPath?dispatch=true HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
        String responseString = this._connector.getResponses(request);
        BufferedReader br = this.parseHeader(responseString);
        junit.framework.Assert.assertEquals((String)"servlet gets right path", (String)"doGet:getServletPath:/servletPath2", (String)br.readLine());
        junit.framework.Assert.assertEquals((String)"async context gets right path in get", (String)"doGet:async:getServletPath:/servletPath2", (String)br.readLine());
        junit.framework.Assert.assertEquals((String)"servlet path attr is original", (String)"async:run:attr:servletPath:/servletPath", (String)br.readLine());
        junit.framework.Assert.assertEquals((String)"path info attr is correct", (String)"async:run:attr:pathInfo:null", (String)br.readLine());
        junit.framework.Assert.assertEquals((String)"query string attr is correct", (String)"async:run:attr:queryString:dispatch=true", (String)br.readLine());
        junit.framework.Assert.assertEquals((String)"context path attr is correct", (String)"async:run:attr:contextPath:", (String)br.readLine());
        junit.framework.Assert.assertEquals((String)"request uri attr is correct", (String)"async:run:attr:requestURI:/servletPath", (String)br.readLine());
    }

    @Test
    public void testDispatchAsyncContextEncodedPathAndQueryString() throws Exception {
        String request = "GET /path%20with%20spaces/servletPath?dispatch=true&queryStringWithEncoding=space%20space HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
        String responseString = this._connector.getResponses(request);
        BufferedReader br = this.parseHeader(responseString);
        Assert.assertThat((String)"servlet gets right path", (Object)br.readLine(), (Matcher)Matchers.equalTo((Object)"doGet:getServletPath:/servletPath2"));
        Assert.assertThat((String)"async context gets right path in get", (Object)br.readLine(), (Matcher)Matchers.equalTo((Object)"doGet:async:getServletPath:/servletPath2"));
        Assert.assertThat((String)"servlet path attr is original", (Object)br.readLine(), (Matcher)Matchers.equalTo((Object)"async:run:attr:servletPath:/path with spaces/servletPath"));
        Assert.assertThat((String)"path info attr is correct", (Object)br.readLine(), (Matcher)Matchers.equalTo((Object)"async:run:attr:pathInfo:null"));
        Assert.assertThat((String)"query string attr is correct", (Object)br.readLine(), (Matcher)Matchers.equalTo((Object)"async:run:attr:queryString:dispatch=true&queryStringWithEncoding=space%20space"));
        Assert.assertThat((String)"context path attr is correct", (Object)br.readLine(), (Matcher)Matchers.equalTo((Object)"async:run:attr:contextPath:"));
        Assert.assertThat((String)"request uri attr is correct", (Object)br.readLine(), (Matcher)Matchers.equalTo((Object)"async:run:attr:requestURI:/path%20with%20spaces/servletPath"));
    }

    @Test
    public void testSimpleWithContextAsyncContext() throws Exception {
        this._contextHandler.setContextPath("/foo");
        String request = "GET /foo/servletPath HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
        String responseString = this._connector.getResponses(request);
        BufferedReader br = this.parseHeader(responseString);
        junit.framework.Assert.assertEquals((String)"servlet gets right path", (String)"doGet:getServletPath:/servletPath", (String)br.readLine());
        junit.framework.Assert.assertEquals((String)"async context gets right path in get", (String)"doGet:async:getServletPath:/servletPath", (String)br.readLine());
        junit.framework.Assert.assertEquals((String)"async context gets right path in async", (String)"async:run:attr:servletPath:/servletPath", (String)br.readLine());
    }

    @Test
    public void testDispatchWithContextAsyncContext() throws Exception {
        this._contextHandler.setContextPath("/foo");
        String request = "GET /foo/servletPath?dispatch=true HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
        String responseString = this._connector.getResponses(request);
        BufferedReader br = this.parseHeader(responseString);
        junit.framework.Assert.assertEquals((String)"servlet gets right path", (String)"doGet:getServletPath:/servletPath2", (String)br.readLine());
        junit.framework.Assert.assertEquals((String)"async context gets right path in get", (String)"doGet:async:getServletPath:/servletPath2", (String)br.readLine());
        junit.framework.Assert.assertEquals((String)"servlet path attr is original", (String)"async:run:attr:servletPath:/servletPath", (String)br.readLine());
        junit.framework.Assert.assertEquals((String)"path info attr is correct", (String)"async:run:attr:pathInfo:null", (String)br.readLine());
        junit.framework.Assert.assertEquals((String)"query string attr is correct", (String)"async:run:attr:queryString:dispatch=true", (String)br.readLine());
        junit.framework.Assert.assertEquals((String)"context path attr is correct", (String)"async:run:attr:contextPath:/foo", (String)br.readLine());
        junit.framework.Assert.assertEquals((String)"request uri attr is correct", (String)"async:run:attr:requestURI:/foo/servletPath", (String)br.readLine());
    }

    @Test
    public void testDispatch() throws Exception {
        String request = "GET /forward HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
        String responseString = this._connector.getResponses(request);
        BufferedReader br = this.parseHeader(responseString);
        Assert.assertThat((String)"!ForwardingServlet", (Object)br.readLine(), (Matcher)Matchers.equalTo((Object)"Dispatched back to ForwardingServlet"));
    }

    @Test
    public void testDispatchRequestResponse() throws Exception {
        String request = "GET /forward?dispatchRequestResponse=true HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
        String responseString = this._connector.getResponses(request);
        BufferedReader br = this.parseHeader(responseString);
        Assert.assertThat((String)"!AsyncDispatchingServlet", (Object)br.readLine(), (Matcher)Matchers.equalTo((Object)"Dispatched back to AsyncDispatchingServlet"));
    }

    private BufferedReader parseHeader(String responseString) throws IOException {
        BufferedReader br = new BufferedReader(new StringReader(responseString));
        Assert.assertEquals((Object)"HTTP/1.1 200 OK", (Object)br.readLine());
        br.readLine();
        br.readLine();
        br.readLine();
        return br;
    }

    @After
    public void tearDown() throws Exception {
        this._server.stop();
        this._server.join();
    }

    private class Wrapper
    extends HttpServletResponseWrapper {
        public Wrapper(HttpServletResponse response) {
            super(response);
        }
    }

    private class AsyncRunnable
    implements Runnable {
        private AsyncContext _context;

        public AsyncRunnable(AsyncContext context) {
            this._context = context;
        }

        @Override
        public void run() {
            HttpServletRequest req = (HttpServletRequest)this._context.getRequest();
            try {
                this._context.getResponse().getOutputStream().print("async:run:attr:servletPath:" + req.getAttribute("javax.servlet.async.servlet_path") + "\n");
                this._context.getResponse().getOutputStream().print("async:run:attr:pathInfo:" + req.getAttribute("javax.servlet.async.path_info") + "\n");
                this._context.getResponse().getOutputStream().print("async:run:attr:queryString:" + req.getAttribute("javax.servlet.async.query_string") + "\n");
                this._context.getResponse().getOutputStream().print("async:run:attr:contextPath:" + req.getAttribute("javax.servlet.async.context_path") + "\n");
                this._context.getResponse().getOutputStream().print("async:run:attr:requestURI:" + req.getAttribute("javax.servlet.async.request_uri") + "\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this._context.complete();
        }
    }

    private class TestServlet2
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        private TestServlet2() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.getOutputStream().print("doGet:getServletPath:" + request.getServletPath() + "\n");
            AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
            response.getOutputStream().print("doGet:async:getServletPath:" + ((HttpServletRequest)asyncContext.getRequest()).getServletPath() + "\n");
            asyncContext.start((Runnable)new AsyncRunnable(asyncContext));
        }
    }

    private class TestServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        private TestServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            if (request.getParameter("dispatch") != null) {
                AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
                asyncContext.dispatch("/servletPath2");
            } else {
                response.getOutputStream().print("doGet:getServletPath:" + request.getServletPath() + "\n");
                AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
                response.getOutputStream().print("doGet:async:getServletPath:" + ((HttpServletRequest)asyncContext.getRequest()).getServletPath() + "\n");
                asyncContext.start((Runnable)new AsyncRunnable(asyncContext));
            }
        }
    }

    private class DispatchingRunnable
    implements Runnable {
        private AsyncContext asyncContext;
        private boolean wrapped;

        public DispatchingRunnable(AsyncContext asyncContext, boolean wrapped) {
            this.asyncContext = asyncContext;
            this.wrapped = wrapped;
        }

        @Override
        public void run() {
            if (this.wrapped) {
                Assert.assertTrue((boolean)(this.asyncContext.getResponse() instanceof Wrapper));
            }
            this.asyncContext.dispatch();
        }
    }

    private class AsyncDispatchingServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        private AsyncDispatchingServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
            Request request = (Request)req;
            if (request.getDispatcherType() == DispatcherType.ASYNC) {
                response.getOutputStream().print("Dispatched back to AsyncDispatchingServlet");
            } else {
                AsyncContext asyncContext;
                boolean wrapped = false;
                if (request.getParameter("dispatchRequestResponse") != null) {
                    wrapped = true;
                    asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)new Wrapper(response));
                } else {
                    asyncContext = request.startAsync();
                }
                new Thread(new DispatchingRunnable(asyncContext, wrapped)).start();
            }
        }
    }

    private class ForwardingServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        private ForwardingServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            if (((Request)request).getDispatcherType() == DispatcherType.ASYNC) {
                response.getOutputStream().print("Dispatched back to ForwardingServlet");
            } else {
                request.getRequestDispatcher("/dispatchingServlet").forward((ServletRequest)request, (ServletResponse)response);
            }
        }
    }
}

