/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.AssertionFailedError;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandlerContainer;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ServletContextHandlerTest {
    private Server _server;
    private LocalConnector _connector;

    @Before
    public void createServer() {
        this._server = new Server();
        this._connector = new LocalConnector();
        this._server.addConnector((Connector)this._connector);
    }

    @After
    public void destroyServer() throws Exception {
        this._server.stop();
        this._server.join();
    }

    @Test
    public void testFindContainer() throws Exception {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this._server.setHandler((Handler)contexts);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)contexts, "/", 1);
        SessionHandler session = root.getSessionHandler();
        ServletHandler servlet = root.getServletHandler();
        ConstraintSecurityHandler security = new ConstraintSecurityHandler();
        root.setSecurityHandler((SecurityHandler)security);
        this._server.start();
        Assert.assertEquals((Object)root, (Object)AbstractHandlerContainer.findContainerOf((HandlerContainer)this._server, ContextHandler.class, (Handler)session));
        Assert.assertEquals((Object)root, (Object)AbstractHandlerContainer.findContainerOf((HandlerContainer)this._server, ContextHandler.class, (Handler)security));
        Assert.assertEquals((Object)root, (Object)AbstractHandlerContainer.findContainerOf((HandlerContainer)this._server, ContextHandler.class, (Handler)servlet));
    }

    @Test
    public void testAddServletAfterStart() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.addServlet(TestServlet.class, "/test");
        context.setContextPath("/");
        this._server.setHandler((Handler)context);
        this._server.start();
        StringBuffer request = new StringBuffer();
        request.append("GET /test HTTP/1.1\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponses(request.toString());
        this.assertResponseContains("Test", response);
        context.addServlet(HelloServlet.class, "/hello");
        request = new StringBuffer();
        request.append("GET /hello HTTP/1.1\n");
        request.append("Host: localhost\n");
        request.append("\n");
        response = this._connector.getResponses(request.toString());
        this.assertResponseContains("Hello World", response);
    }

    @Test
    public void testReplaceServletHandlerWithServlet() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.addServlet(TestServlet.class, "/test");
        context.setContextPath("/");
        this._server.setHandler((Handler)context);
        this._server.start();
        StringBuffer request = new StringBuffer();
        request.append("GET /test HTTP/1.1\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponses(request.toString());
        this.assertResponseContains("Test", response);
        context.stop();
        ServletHandler srvHnd = new ServletHandler();
        srvHnd.addServletWithMapping(HelloServlet.class, "/hello");
        context.setServletHandler(srvHnd);
        context.start();
        request = new StringBuffer();
        request.append("GET /hello HTTP/1.1\n");
        request.append("Host: localhost\n");
        request.append("\n");
        response = this._connector.getResponses(request.toString());
        this.assertResponseContains("Hello World", response);
    }

    @Test
    public void testReplaceServletHandlerWithoutServlet() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.addServlet(TestServlet.class, "/test");
        context.setContextPath("/");
        this._server.setHandler((Handler)context);
        this._server.start();
        StringBuffer request = new StringBuffer();
        request.append("GET /test HTTP/1.1\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponses(request.toString());
        this.assertResponseContains("Test", response);
        context.stop();
        ServletHandler srvHnd = new ServletHandler();
        context.setServletHandler(srvHnd);
        context.start();
        context.addServlet(HelloServlet.class, "/hello");
        request = new StringBuffer();
        request.append("GET /hello HTTP/1.1\n");
        request.append("Host: localhost\n");
        request.append("\n");
        response = this._connector.getResponses(request.toString());
        this.assertResponseContains("Hello World", response);
    }

    private int assertResponseContains(String expected, String response) {
        int idx = response.indexOf(expected);
        if (idx == -1) {
            StringBuffer err = new StringBuffer();
            err.append("Response does not contain expected string \"").append(expected).append("\"");
            err.append("\n").append(response);
            System.err.println(err);
            throw new AssertionFailedError(err.toString());
        }
        return idx;
    }

    public static class TestServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setStatus(200);
            PrintWriter writer = resp.getWriter();
            writer.write("Test");
        }
    }

    public static class HelloServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setStatus(200);
            PrintWriter writer = resp.getWriter();
            writer.write("Hello World");
        }
    }
}

