/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import javax.servlet.Servlet;
import junit.framework.AssertionFailedError;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.StatisticsServlet;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class StatisticsServletTest {
    private Server server;
    private LocalConnector connector;
    private ServletContextHandler context;

    @Before
    public void init() throws Exception {
        this.server = new Server();
        this.server.setSendServerVersion(false);
        this.context = new ServletContextHandler();
        this.context.setContextPath("/");
        ServletHolder holder = new ServletHolder();
        holder.setServlet((Servlet)new StatisticsServlet());
        holder.setInitParameter("restrictToLocalhost", "false");
        this.context.addServlet(holder, "/stats");
        this.server.setHandler((Handler)this.context);
        this.connector = new LocalConnector();
        this.server.addConnector((Connector)this.connector);
    }

    @After
    public void destroy() throws Exception {
        this.server.stop();
        this.server.join();
    }

    @Test
    public void testNoHandler() throws Exception {
        this.server.start();
        StringBuffer req1 = new StringBuffer();
        req1.append("GET /stats HTTP/1.1\n");
        req1.append("Host: localhost\n");
        req1.append("\n");
        String response = this.connector.getResponses(req1.toString());
        this.assertResponseContains("503", response);
    }

    @Test
    public void testWithHandler() throws Exception {
        StatisticsHandler statsHandler = new StatisticsHandler();
        statsHandler.setHandler((Handler)this.context);
        this.server.setHandler((Handler)statsHandler);
        this.server.start();
        StringBuffer req1 = new StringBuffer();
        req1.append("GET /stats HTTP/1.1\n");
        req1.append("Host: localhost\n");
        req1.append("\n");
        String response = this.connector.getResponses(req1.toString());
        this.assertResponseContains("Statistics gathering started ", response);
    }

    private void assertResponseContains(String expected, String response) {
        int idx = response.indexOf(expected);
        if (idx == -1) {
            StringBuffer err = new StringBuffer();
            err.append("Response does not contain expected string \"").append(expected).append("\"");
            err.append("\n").append(response);
            System.err.println(err);
            throw new AssertionFailedError(err.toString());
        }
    }
}

