/*
 * Decompiled with CFR 0.152.
 */
package com.acme;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieDump
extends HttpServlet {
    int redirectCount = 0;

    protected void handleForm(HttpServletRequest request, HttpServletResponse response) {
        String name = request.getParameter("Name");
        String value = request.getParameter("Value");
        String age = request.getParameter("Age");
        if (name != null && name.length() > 0) {
            Cookie cookie = new Cookie(name, value);
            if (age != null && age.length() > 0) {
                cookie.setMaxAge(Integer.parseInt(age));
            }
            response.addCookie(cookie);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleForm(request, response);
        String nextUrl = this.getURI(request) + "?R=" + this.redirectCount++;
        String encodedUrl = response.encodeRedirectURL(nextUrl);
        response.sendRedirect(encodedUrl);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleForm(request, response);
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<h1>Cookie Dump Servlet:</h1>");
        Cookie[] cookies = request.getCookies();
        for (int i = 0; cookies != null && i < cookies.length; ++i) {
            out.println("<b>" + this.deScript(cookies[i].getName()) + "</b>=" + this.deScript(cookies[i].getValue()) + "<br/>");
        }
        out.println("<form action=\"" + response.encodeURL(this.getURI(request)) + "\" method=\"post\">");
        out.println("<b>Name:</b><input type=\"text\" name=\"Name\" value=\"name\"/><br/>");
        out.println("<b>Value:</b><input type=\"text\" name=\"Value\" value=\"value\"/><br/>");
        out.println("<b>Max-Age:</b><input type=\"text\" name=\"Age\" value=\"60\"/><br/>");
        out.println("<input type=\"submit\" name=\"Action\" value=\"Set\"/>");
    }

    public String getServletInfo() {
        return "Session Dump Servlet";
    }

    private String getURI(HttpServletRequest request) {
        String uri = (String)request.getAttribute("javax.servlet.forward.request_uri");
        if (uri == null) {
            uri = request.getRequestURI();
        }
        return uri;
    }

    protected String deScript(String string) {
        if (string == null) {
            return null;
        }
        string = string.replace("&", "&amp;");
        string = string.replace("<", "&lt;");
        string = string.replace(">", "&gt;");
        return string;
    }
}

