/*
 * Decompiled with CFR 0.152.
 */
package com.acme;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.GregorianCalendar;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.util.log.Log;

public class SecureModeServlet
extends HttpServlet {
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        ServletOutputStream out = response.getOutputStream();
        out.println("<html>");
        out.println("  <title>Secure Jetty Test Webapp</title>");
        try {
            this.runPropertyChecks(out);
            this.runFileSystemChecks(out);
            this.runLoggingChecks(out);
            this.runClassloaderChecks(out);
        }
        catch (Exception e) {
            e.printStackTrace(new PrintStream((OutputStream)out));
        }
        out.println("</html>");
        out.flush();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            this.getServletContext().log("exception", (Throwable)e);
        }
    }

    private void runClassloaderChecks(ServletOutputStream out) throws Exception {
        out.println("    <h1>Checking Classloader Setup</h1>");
        out.println("      <p>");
        System.getProperty("user.dir");
        try {
            out.println("check ability to create classloader<br/>");
            URL url = new URL("http://not.going.to.work");
            new URLClassLoader(new URL[]{url});
            out.println("status: <b>SUCCESS - unexpected</b><br/>");
        }
        catch (SecurityException e) {
            out.println("status: <b>FAILURE - expected</b><br/>");
        }
        out.println("      </p><br/><br/>");
    }

    private void runLoggingChecks(ServletOutputStream out) throws Exception {
        out.println("    <h1>Checking File System</h1>");
        out.println("      <p>");
        String userDir = System.getProperty("user.dir");
        try {
            out.println("check ability to log<br/>");
            Log.info((String)"testing logging");
            out.println("status: <b>SUCCESS - expected</b><br/>");
        }
        catch (SecurityException e) {
            out.println("status: <b>FAILURE - unexpected</b><br/>");
            out.println("<table><tr><td>");
            e.printStackTrace(new PrintStream((OutputStream)out));
            out.println("</td></tr></table>");
        }
        try {
            GregorianCalendar c = new GregorianCalendar();
            String logFile = c.get(1) + "_" + c.get(2) + "_" + c.get(5) + ".request.log";
            out.println("check ability to access log file directly<br/>");
            File jettyHomeFile = new File(userDir + File.separator + "logs" + File.separator + logFile);
            jettyHomeFile.canRead();
            out.println("status: <b>SUCCESS - unexpected</b><br/>");
        }
        catch (SecurityException e) {
            out.println("status: <b>FAILURE - expected</b><br/>");
        }
        out.println("      </p><br/><br/>");
    }

    private void runFileSystemChecks(ServletOutputStream out) throws Exception {
        File jettyHomeFile;
        out.println("    <h1>Checking File System</h1>");
        out.println("      <p>");
        String userDir = System.getProperty("user.dir");
        try {
            out.println("check read for $jetty.home/lib/policy/jetty.policy<br/>");
            jettyHomeFile = new File(userDir + File.separator + "lib" + File.separator + "policy" + File.separator + "jetty.policy");
            jettyHomeFile.canRead();
            out.println("status: <b>SUCCESS - expected</b><br/>");
        }
        catch (SecurityException e) {
            out.println("status: <b>FAILURE - unexpected</b><br/>");
            out.println("<table><tr><td>");
            e.printStackTrace(new PrintStream((OutputStream)out));
            out.println("</td></tr></table>");
        }
        try {
            out.println("check write permission for $jetty.home/lib/policy/jetty.policy<br/>");
            jettyHomeFile = new File(userDir + File.separator + "lib" + File.separator + "policy" + File.separator + "jetty.policy");
            jettyHomeFile.canWrite();
            out.println("status: <b>SUCCESS - unexpected</b><br/>");
        }
        catch (SecurityException e) {
            out.println("status: <b>FAILURE - expected</b><br/>");
        }
        try {
            out.println("check read permission for $jetty.home/lib<br/>");
            jettyHomeFile = new File(userDir + File.separator + "lib");
            jettyHomeFile.canRead();
            out.println("status: <b>SUCCESS - unexpected</b><br/>");
        }
        catch (SecurityException e) {
            out.println("status: <b>FAILURE - expected</b><br/>");
        }
        try {
            out.println("check write permission for $jetty.home/lib<br/>");
            jettyHomeFile = new File(userDir + File.separator + "lib");
            jettyHomeFile.canWrite();
            out.println("status: <b>SUCCESS - unexpected</b><br/>");
        }
        catch (SecurityException e) {
            out.println("status: <b>FAILURE - expected</b><br/>");
        }
        try {
            out.println("check read permission for $jetty.home<br/>");
            jettyHomeFile = new File(userDir + File.separator);
            jettyHomeFile.canRead();
            out.println("status: <b>SUCCESS - unexpected</b><br/>");
        }
        catch (SecurityException e) {
            out.println("status: <b>FAILURE - expected</b><br/>");
        }
        try {
            out.println("check write permission for $jetty.home<br/>");
            jettyHomeFile = new File(userDir + File.separator);
            jettyHomeFile.canWrite();
            out.println("status: <b>SUCCESS - unexpected</b><br/>");
        }
        catch (SecurityException e) {
            out.println("status: <b>FAILURE - expected</b><br/>");
        }
        try {
            out.println("check read permission for $jetty.home/logs<br/>");
            jettyHomeFile = new File(userDir + File.separator + "logs" + File.separator);
            jettyHomeFile.canRead();
            out.println("status: <b>SUCCESS - unexpected</b><br/>");
        }
        catch (SecurityException e) {
            out.println("status: <b>FAILURE - expected</b><br/>");
        }
        try {
            out.println("check read permission for $jetty.home/logs<br/>");
            jettyHomeFile = new File(userDir + File.separator + "logs");
            jettyHomeFile.canWrite();
            out.println("status: <b>SUCCESS - unexpected</b><br/>");
        }
        catch (SecurityException e) {
            out.println("status: <b>FAILURE - expected</b><br/>");
        }
        out.println("      </p><br/><br/>");
    }

    private void runPropertyChecks(ServletOutputStream out) throws IOException {
        String value;
        out.println("    <h1>Checking Properties</h1>");
        out.println("    <h3>Declared Property - read</h3>");
        out.println("      <p>");
        try {
            out.println("check read permission for __ALLOWED_READ_PROPERTY <br/>");
            System.getProperty("__ALLOWED_READ_PROPERTY");
            out.println("status: <b>SUCCESS - expected</b><br/>");
        }
        catch (SecurityException e) {
            out.println("status: <b>FAILURE - unexpected</b><br/>");
            out.println("<table><tr><td>");
            e.printStackTrace(new PrintStream((OutputStream)out));
            out.println("</td></tr></table>");
        }
        try {
            out.println("check write permission for __ALLOWED_READ_PROPERTY<br/>");
            System.setProperty("__ALLOWED_READ_PROPERTY", "SUCCESS - unexpected");
            value = System.getProperty("__ALLOWED_READ_PROPERTY");
            out.println("status: <b>" + value + "</b><br/>");
        }
        catch (SecurityException e) {
            out.println("status: <b>FAILURE - expected</b><br/>");
        }
        out.println("      </p><br/><br/>");
        out.println("    <h3>Declared Property - read/write</h3>");
        out.println("      <p>");
        try {
            out.println("check read permission for __ALLOWED_WRITE_PROPERTY<br/>");
            System.getProperty("__ALLOWED_WRITE_PROPERTY");
            out.println("Status: <b>SUCCESS - expected</b><br/>");
        }
        catch (SecurityException e) {
            out.println("status: <b>FAILURE - unexpected</b><br/>");
            out.println("<table><tr><td>");
            e.printStackTrace(new PrintStream((OutputStream)out));
            out.println("</td></tr></table>");
        }
        try {
            out.println("check write permission for __ALLOWED_WRITE_PROPERTY<br/>");
            System.setProperty("__ALLOWED_WRITE_PROPERTY", "SUCCESS - expected");
            value = System.getProperty("__ALLOWED_WRITE_PROPERTY");
            out.println("status: <b>" + value + "</b><br/>");
        }
        catch (SecurityException e) {
            out.println("status: <b>FAILURE - unexpected</b><br/>");
            out.println("<table><tr><td>");
            e.printStackTrace(new PrintStream((OutputStream)out));
            out.println("</td></tr></table>");
        }
        out.println("      </p><br/><br/>");
        out.println("    <h3>checking forbidden properties</h3>");
        out.println("      <p>");
        try {
            out.println("check read permission for __UNDECLARED_PROPERTY: <br/>");
            System.getProperty("__UNDECLARED_PROPERTY");
            out.println("status: <b>SUCCESS - expected</b><br/>");
        }
        catch (SecurityException e) {
            out.println("status: <b>FAILURE - expected</b><br/>");
        }
        try {
            out.println("check write permission for __UNDECLARED_PROPERTY: <br/>");
            System.setProperty("__UNDECLARED_PROPERTY", "SUCCESS - unexpected");
            value = System.getProperty("__UNDECLARED_PROPERTY");
            out.println("status: <b>" + value + "</b><br/>");
        }
        catch (SecurityException e) {
            out.println("status: <b>FAILURE - expected</b><br/>");
        }
        out.println("      </p><br/><br/>");
    }
}

