/*
 * Decompiled with CFR 0.152.
 */
package com.acme;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.util.log.Log;

public class TestFilter
implements Filter {
    private boolean _remote;
    private ServletContext _context;
    private final Set<String> _allowed = new HashSet();

    public void init(FilterConfig filterConfig) throws ServletException {
        this._context = filterConfig.getServletContext();
        this._remote = Boolean.parseBoolean(filterConfig.getInitParameter("remote"));
        this._allowed.add("/favicon.ico");
        this._allowed.add("/jetty_banner.gif");
        Log.debug((String)("TestFilter#remote=" + this._remote));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String from = request.getRemoteHost();
        String to = request.getServerName();
        String path = ((HttpServletRequest)request).getServletPath();
        if (!(this._remote || this._allowed.contains(path) || (from.equals("localhost") || from.startsWith("127.") || from.indexOf(":1") >= 0) && (to.equals("localhost") || to.startsWith("127.0.0.") || to.indexOf(":1") >= 0))) {
            if ("/".equals(path)) {
                this._context.getRequestDispatcher("/remote.html").forward(request, response);
            } else {
                ((HttpServletResponse)response).sendRedirect("/remote.html");
            }
            return;
        }
        Integer old_value = null;
        ServletRequest r = request;
        while (r instanceof ServletRequestWrapper) {
            r = ((ServletRequestWrapper)r).getRequest();
        }
        try {
            old_value = (Integer)request.getAttribute("testFilter");
            Integer value = old_value == null ? new Integer(1) : new Integer(old_value + 1);
            request.setAttribute("testFilter", (Object)value);
            String qString = ((HttpServletRequest)request).getQueryString();
            if (qString != null && qString.indexOf("wrap") >= 0) {
                request = new HttpServletRequestWrapper((HttpServletRequest)request);
            }
            this._context.setAttribute("request" + r.hashCode(), (Object)value);
            chain.doFilter(request, response);
        }
        finally {
            request.setAttribute("testFilter", (Object)old_value);
            this._context.setAttribute("request" + r.hashCode(), (Object)old_value);
        }
    }

    public void destroy() {
    }
}

