/*
 * Decompiled with CFR 0.152.
 */
package com.acme;

import com.acme.ChatServlet;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationSupport;

public class ChatServlet
extends HttpServlet {
    Map<String, Map<String, Member>> _rooms = new HashMap();

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String action = request.getParameter("action");
        String message = request.getParameter("message");
        String username = request.getParameter("user");
        if (action.equals("join")) {
            this.join(request, response, username);
        } else if (action.equals("poll")) {
            this.poll(request, response, username);
        } else if (action.equals("chat")) {
            this.chat(request, response, username, message);
        }
    }

    private synchronized void join(HttpServletRequest request, HttpServletResponse response, String username) throws IOException {
        Member member = new Member(this);
        member._name = username;
        HashMap<String, Member> room = (HashMap<String, Member>)this._rooms.get(request.getPathInfo());
        if (room == null) {
            room = new HashMap<String, Member>();
            this._rooms.put(request.getPathInfo(), room);
        }
        room.put(username, member);
        response.setContentType("text/json;charset=utf-8");
        PrintWriter out = response.getWriter();
        out.print("{action:\"join\"}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void poll(HttpServletRequest request, HttpServletResponse response, String username) throws IOException {
        Map room = (Map)this._rooms.get(request.getPathInfo());
        if (room == null) {
            response.sendError(503);
            return;
        }
        Member member = (Member)room.get(username);
        if (member == null) {
            response.sendError(503);
            return;
        }
        Member member2 = member;
        synchronized (member2) {
            if (member._queue.size() > 0) {
                response.setContentType("text/json;charset=utf-8");
                StringBuilder buf = new StringBuilder();
                buf.append("{\"action\":\"poll\",");
                buf.append("\"from\":\"");
                buf.append((String)member._queue.poll());
                buf.append("\",");
                String message = (String)member._queue.poll();
                int quote = message.indexOf(34);
                while (quote >= 0) {
                    message = message.substring(0, quote) + '\\' + message.substring(quote);
                    quote = message.indexOf(34, quote + 2);
                }
                buf.append("\"chat\":\"");
                buf.append(message);
                buf.append("\"}");
                byte[] bytes = buf.toString().getBytes("utf-8");
                response.setContentLength(bytes.length);
                response.getOutputStream().write(bytes);
            } else {
                Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)request);
                if (continuation.isInitial()) {
                    continuation.setTimeout(20000L);
                    continuation.suspend();
                    member._continuation = continuation;
                } else {
                    response.setContentType("text/json;charset=utf-8");
                    PrintWriter out = response.getWriter();
                    out.print("{action:\"poll\"}");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void chat(HttpServletRequest request, HttpServletResponse response, String username, String message) throws IOException {
        Map room = (Map)this._rooms.get(request.getPathInfo());
        if (room != null) {
            Iterator i$ = room.values().iterator();
            while (i$.hasNext()) {
                Member m;
                Member member = m = (Member)i$.next();
                synchronized (member) {
                    m._queue.add(username);
                    m._queue.add(message);
                    if (m._continuation != null) {
                        m._continuation.resume();
                        m._continuation = null;
                    }
                }
            }
        }
        response.setContentType("text/json;charset=utf-8");
        PrintWriter out = response.getWriter();
        out.print("{action:\"chat\"}");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getParameter("action") != null) {
            this.doPost(request, response);
        } else {
            this.getServletContext().getNamedDispatcher("default").forward((ServletRequest)request, (ServletResponse)response);
        }
    }
}

