/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.jms.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLStreamHandler;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import org.apache.qpid.amqp_1_0.jms.ConnectionFactory;
import org.apache.qpid.amqp_1_0.jms.impl.ConnectionImpl;

public class ConnectionFactoryImpl
implements ConnectionFactory,
TopicConnectionFactory,
QueueConnectionFactory {
    private String _host;
    private int _port;
    private String _username;
    private String _password;
    private String _clientId;
    private String _remoteHost;
    private boolean _ssl;
    private String _queuePrefix;
    private String _topicPrefix;
    private boolean _useBinaryMessageId = Boolean.parseBoolean(System.getProperty("qpid.use_binary_message_id", "true"));
    private boolean _syncPublish = Boolean.parseBoolean(System.getProperty("qpid.sync_publish", "false"));
    private int _maxSessions = Integer.getInteger("qpid.max_sessions", 0);

    public ConnectionFactoryImpl(String host, int port, String username, String password) {
        this(host, port, username, password, null, false);
    }

    public ConnectionFactoryImpl(String host, int port, String username, String password, String clientId) {
        this(host, port, username, password, clientId, false);
    }

    public ConnectionFactoryImpl(String host, int port, String username, String password, String clientId, boolean ssl) {
        this(host, port, username, password, clientId, null, ssl);
    }

    public ConnectionFactoryImpl(String host, int port, String username, String password, String clientId, String remoteHost, boolean ssl) {
        this(host, port, username, password, clientId, remoteHost, ssl, 0);
    }

    public ConnectionFactoryImpl(String host, int port, String username, String password, String clientId, String remoteHost, boolean ssl, int maxSessions) {
        this._host = host;
        this._port = port;
        this._username = username;
        this._password = password;
        this._clientId = clientId;
        this._remoteHost = remoteHost;
        this._ssl = ssl;
        this._maxSessions = maxSessions;
    }

    @Override
    public ConnectionImpl createConnection() throws JMSException {
        return this.createConnection(this._username, this._password);
    }

    @Override
    public ConnectionImpl createConnection(String username, String password) throws JMSException {
        ConnectionImpl connection = new ConnectionImpl(this._host, this._port, username, password, this._clientId, this._remoteHost, this._ssl, this._maxSessions);
        connection.setQueuePrefix(this._queuePrefix);
        connection.setTopicPrefix(this._topicPrefix);
        connection.setUseBinaryMessageId(this._useBinaryMessageId);
        connection.setSyncPublish(this._syncPublish);
        return connection;
    }

    public static ConnectionFactoryImpl createFromURL(String urlString) throws MalformedURLException {
        String query;
        URL url = new URL(null, urlString, new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL u) throws IOException {
                throw new UnsupportedOperationException();
            }
        });
        String protocol = url.getProtocol();
        if (protocol == null || "".equals(protocol)) {
            protocol = "amqp";
        } else if (!protocol.equals("amqp") && !protocol.equals("amqps")) {
            throw new MalformedURLException("Protocol '" + protocol + "' unknown. Must be one of 'amqp' or 'amqps'.");
        }
        String host = url.getHost();
        int port = url.getPort();
        boolean ssl = false;
        if (port == -1) {
            if ("amqps".equals(protocol)) {
                port = 5671;
                ssl = true;
            } else {
                port = 5672;
            }
        } else if ("amqps".equals(protocol)) {
            ssl = true;
        }
        String userInfo = url.getUserInfo();
        String username = null;
        String password = null;
        String clientId = null;
        String remoteHost = null;
        boolean binaryMessageId = true;
        boolean syncPublish = false;
        int maxSessions = 0;
        if (userInfo != null) {
            String[] components = userInfo.split(":", 2);
            username = URLDecoder.decode(components[0]);
            if (components.length == 2) {
                password = URLDecoder.decode(components[1]);
            }
        }
        if ((query = url.getQuery()) != null) {
            for (String param : query.split("&")) {
                String[] keyValuePair = param.split("=", 2);
                if (keyValuePair[0].equalsIgnoreCase("clientid")) {
                    clientId = keyValuePair[1];
                    continue;
                }
                if (keyValuePair[0].equalsIgnoreCase("ssl")) {
                    ssl = Boolean.valueOf(keyValuePair[1]);
                    continue;
                }
                if (keyValuePair[0].equalsIgnoreCase("remote-host")) {
                    remoteHost = keyValuePair[1];
                    continue;
                }
                if (keyValuePair[0].equalsIgnoreCase("binary-messageid")) {
                    binaryMessageId = Boolean.parseBoolean(keyValuePair[1]);
                    continue;
                }
                if (keyValuePair[0].equalsIgnoreCase("sync-publish")) {
                    syncPublish = Boolean.parseBoolean(keyValuePair[1]);
                    continue;
                }
                if (!keyValuePair[0].equalsIgnoreCase("max-sessions")) continue;
                maxSessions = Integer.parseInt(keyValuePair[1]);
            }
        }
        if (remoteHost == null) {
            remoteHost = host;
        }
        ConnectionFactoryImpl connectionFactory = new ConnectionFactoryImpl(host, port, username, password, clientId, remoteHost, ssl, maxSessions);
        connectionFactory.setUseBinaryMessageId(binaryMessageId);
        connectionFactory.setSyncPublish(syncPublish);
        return connectionFactory;
    }

    public QueueConnection createQueueConnection() throws JMSException {
        ConnectionImpl connection = this.createConnection();
        connection.setQueueConnection(true);
        return connection;
    }

    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        ConnectionImpl connection = this.createConnection(username, password);
        connection.setQueueConnection(true);
        return connection;
    }

    public TopicConnection createTopicConnection() throws JMSException {
        ConnectionImpl connection = this.createConnection();
        connection.setTopicConnection(true);
        return connection;
    }

    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        ConnectionImpl connection = this.createConnection(username, password);
        connection.setTopicConnection(true);
        return connection;
    }

    public String getTopicPrefix() {
        return this._topicPrefix;
    }

    public void setTopicPrefix(String topicPrefix) {
        this._topicPrefix = topicPrefix;
    }

    public String getQueuePrefix() {
        return this._queuePrefix;
    }

    public void setQueuePrefix(String queuePrefix) {
        this._queuePrefix = queuePrefix;
    }

    public void setUseBinaryMessageId(boolean useBinaryMessageId) {
        this._useBinaryMessageId = useBinaryMessageId;
    }

    public void setSyncPublish(boolean syncPublish) {
        this._syncPublish = syncPublish;
    }
}

