/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.codec;

import java.nio.ByteBuffer;
import org.apache.qpid.amqp_1_0.codec.SimpleVariableWidthWriter;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;

public class ByteBufferWriter
extends SimpleVariableWidthWriter<ByteBuffer> {
    private static ValueWriter.Factory<ByteBuffer> FACTORY = new ValueWriter.Factory<ByteBuffer>(){

        @Override
        public ValueWriter<ByteBuffer> newInstance(ValueWriter.Registry registry) {
            return new ByteBufferWriter();
        }
    };

    @Override
    protected byte getFourOctetEncodingCode() {
        return -80;
    }

    @Override
    protected byte getSingleOctetEncodingCode() {
        return -96;
    }

    @Override
    protected byte[] getByteArray(ByteBuffer value) {
        if (value.hasArray() && value.arrayOffset() == 0 && value.remaining() == value.array().length) {
            return value.array();
        }
        byte[] copy = new byte[value.remaining()];
        value.duplicate().get(copy);
        return copy;
    }

    @Override
    protected int getOffset() {
        return 0;
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(ByteBuffer.class, FACTORY);
    }
}

